/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.adminchrome.components.entity;

import com.atlassian.crowd.plugin.adminchrome.components.entity.ResourceEntity;
import java.util.List;
import javax.annotation.Nonnull;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
public class ComponentEntity {
    private final String name;
    private final boolean visible;
    private final String location;
    private final String version;
    private final ResourceEntity resources;

    public ComponentEntity(@Nonnull String name, boolean visible, String location, String version, ResourceEntity resources) {
        this.name = name;
        this.visible = visible;
        this.location = location;
        this.version = version;
        this.resources = resources;
    }

    public String getName() {
        return this.name;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String getLocation() {
        return this.location;
    }

    public String getVersion() {
        return this.version;
    }

    public ResourceEntity getResources() {
        return this.resources;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ComponentEntity)) {
            return false;
        }
        ComponentEntity that = (ComponentEntity)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static class Builder {
        private String name;
        private boolean visible;
        private String location;
        private String version;
        private List<String> jsResources;
        private List<String> cssResources;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withVisibility(boolean visible) {
            this.visible = visible;
            return this;
        }

        public Builder withLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withJsResources(List<String> jsResources) {
            this.jsResources = jsResources;
            return this;
        }

        public Builder withCssResources(List<String> cssResources) {
            this.cssResources = cssResources;
            return this;
        }

        public ComponentEntity build() {
            return new ComponentEntity(this.name, this.visible, this.location, this.version, new ResourceEntity(this.jsResources, this.cssResources));
        }
    }
}

