require(['aui/form-notification']);

(function ($, root, adminApp) {
    var INVITE_EXPIRY_STORAGE_KEY = 'uum.invite.expiryDays';
    var DEFAULT_INVITE_EXPIRY = 7;
    var CREATE_ANOTHER_STORAGE_KEY = "create-another";
    var flag = require('aui/flag');

    var ignoredFields = [
        'create-another'
    ];

    // IE doesn't support location.origin
    location.origin = location.origin || (location.protocol + "//" + location.host);

    root.routes = root.routes || {};
    root.routes.users = root.routes.users || {};
    var userRoutes = root.routes.users;
    var helpers = root.helpers;
    var manipulation = root.manipulation;

    userRoutes.list = function (params) {
        // Render actions bar - where search etc is
        helpers.updateContent(usermanagement.users.actions());

        helpers.ajax.getUserCount().then(function(numberOfUsers){
            var quickAdd = $("#new-user-quick-add");
            if (numberOfUsers <= 5) {
                quickAdd.parent()
                    .addClass('quick-add-toggled')
                    .removeClass('no-quick-add');
                quickAdd.find('input').first().focus();
            } else {
                quickAdd.parent()
                    .removeClass('quick-add-toggled')
                    .addClass('no-quick-add');
            }
        });

        var $actions = $("#dataActions")
            .removeClass("hidden")
            .on("change", "#user-types", function () {
                if (dataTable) {
                    dataTable.setQueryParam("userFilters", $(this).val());
                    dataTable.search();
                }
            })
            .on("change", "#user-active-filter", function () {
                if (dataTable) {
                    dataTable.setQueryParam("activeFilter", $(this).val());
                    dataTable.search();
                }
            });

        //defaultQueryParams
        var defaultParams = {};
        defaultParams[helpers.users.ACTIVE_FILTER_NAME] = helpers.users.ACTIVE_FILTER_DEFAULTS;
        defaultParams[helpers.users.USER_TYPE_FILTER_NAME] = helpers.users.USER_TYPE_FILTER_DEFAULTS;

        // Render data table with list of users
        var dataTable = new root.UMDataTable(params.type, {
            searchTriggerContainer: "#users-list-search",
            parse: userRoutes.sanitiseUserData,
            container: params.container,
            loadedCallback: function(table) {
                dataTable.hideBlanket();
                dataTable.highlightNewRows(function () {
                    return _.contains(params.n, $(this).data("username"));
                });
            },
            extraParams: function () {
                return {
                    n: params.n
                };
            },
            defaultQueryParams: defaultParams
        });

        helpers.users.setupActiveFilter($actions.find("form"), dataTable.getQuery());
        helpers.users.setupUserFilter($actions.find("form"), dataTable.getQuery());

        // Initialise search box
        var filterText = dataTable.getQuery().filter;
        if (filterText) {
            dataTable.inputTextField.val(filterText).addClass("has-text");
        }
        dataTable.inputTextField.focus();

        function hideClearSearch(e) {
            //make sure the search is what was changed.
            if (e && !$(e.target).is(dataTable.inputTextField)) {
                return;
            }
            $('#users-list-search').find('.clear-search').toggleClass('hidden', !dataTable.inputTextField.val());
        }

        var previousInput = dataTable.inputTextField.val();

        var delaySearch = _.debounce(function(){
            $('#users-list-search').submit();
        }, 200);

        new root.UMForm('#user-quick-create', 'POST')
            .on("done", function(response){
                helpers.ajax.getLicenseUsage().then(function (licenceUsage) {
                    return userRoutes.messages.displayUserSuccessfullyAddedMessage({
                        isAutoUpgradeModeEnabled: licenceUsage.autoUpgradeMode.enabled,
                        oldLicenseUsages: licenceUsage.products,
                        emailSent: true,
                        users: response
                    });
                }).then(function () {
                    adminApp.app.trigger('list', { type: 'users' });
                });
            });

        return {
            events: {
                'submit #users-list-search': function (e) {
                    e.preventDefault();
                    var filterText = dataTable.inputTextField.val();
                    //setQuery so that we blow away all old filters and pagination
                    dataTable.setQuery('?filter=' + filterText);
                    dataTable.search();
                    dataTable.inputTextField.focus();
                },
                'click .clear-search': function () {
                    dataTable.inputTextField.val("").trigger('change').focus();
                    hideClearSearch();
                    //setQuery so that we blow away all old filters and pagination
                    dataTable.setQuery('');
                    dataTable.showBlanket();
                    dataTable.search();
                    dataTable.inputTextField.focus();
                },
                'click .aui-nav-pagination': function (e) {
                    dataTable.paginationEvent(e);
                },
                // cut and keyup event for IE9
                'input,keyup,cut #list-search-text': function () {
                    var searchValue = $.trim(this.value);

                    // Make sure the searched text is actually different.
                    if (searchValue !== previousInput) {
                        previousInput = searchValue;

                        var hasInput = !!searchValue;
                        dataTable.inputTextField.toggleClass("has-text", hasInput);
                        dataTable.toggleBlanket(true);
                        delaySearch();
                    }
                },
                'click .activationButton': function (event) {
                    var button = $(event.target);
                    var username = button.data('username');
                    button.after(usermanagement.loading());

                    if (button.data('active')) {
                        //the user is currently active, so deactivate
                        deactivateUser(username).done(function(){dataTable.search();});
                    } else {
                        //the user is currently not-active, so activate
                        activateUser(username).done(function(){dataTable.search();});
                    }
                }
        }};
    };

    userRoutes['delete'] = function (params) {
        var username = params.username;
        helpers.updateContent(usermanagement.users.deleteUser({
            username: username
        }));
        $.getJSON(AJS.contextPath() + '/rest/um/1/validation/user/predelete', {
            username: username
        }).done(function (data) {
            $('#user-delete-verifying').replaceWith(usermanagement.users.deleteForm({
                username: username,
                errors: data.errors,
                applicationReferences: data.references,
                hasErrors: data.hasErrors
            }));
            if (!data.hasErrors) {
                // Hook up the actual delete call to the "Delete" button of the form
                var form = new root.UMForm("#user-delete", "delete", {
                    insertErrorsAutomagically: false
                });

                form.on("done" ,function () {
                    flag({
                        type: "success",
                        close: 'auto',
                        body: AJS.I18n.getText("usermanagement.users.delete.success", username)
                    });
                    adminApp.app.navigate('list', { type: 'users' });
                }).on("fail", function () {
                    // we may wish to check (jqXhr.status === 409) here and do something else.
                    adminApp.app.trigger("delete", { type: 'users', username: username });
                });
            }
        }).fail(function (xhr) {
            $('#user-delete-verifying').replaceWith(usermanagement.users.deleteForm({
                username: username,
                hasErrors: true,
                errors: JSON.parse(xhr.responseText).errors
            }));
        });
        return {
            focusedTask: true
        };
    };

    userRoutes.edit = function (params) {
        $.when(getUserDetails(params.username),getPasswordPolicy()).done(function (data, policy) {
            var warnings = [];

            if (data.isSelf) {
                warnings.push(AJS.I18n.getText('usermanagement.warning.cannot.rename.self'));
            }
            if (data.attributes["agni.gapps.user.state"] === "activated") {
                warnings.push(AJS.I18n.getText("usermanagement.warning.rename.googleapps", data.display_name));
            }

            var dialog = new root.UMModal({
                template: usermanagement.users.edit(_.extend({
                    warnings: warnings,
                    policyScore: policy
                }, data)),
                title:  AJS.I18n.getText('usermanagement.users.edit.title'),
                submitButton: AJS.I18n.getText('usermanagement.generic.save')
            });

            $("#display-name").focus();

            new root.UMForm("#user-edit-add", "PUT", {
                dataFormatter: createDataFormatter({})
            }).on("done", function (response) {
                if (response && params.username !== response.name) {
                    flag({
                        type: "success",
                        close: 'auto',
                        body: AJS.I18n.getText("usermanagement.users.success.rename", params.username, response.name)
                    });
                    adminApp.app.navigate('detail', { type: 'users', username: response.name });
                    dialog.remove();
                } else {
                    var name = this.find("[name='name']").val();
                    flag({
                        type: "success",
                        close: 'auto',
                        body: AJS.I18n.getText("usermanagement.users.success.edited", name)
                    });
                    // User details have been updated.
                    getUserDetails.reset(name);
                    getApplicationWithSeats.reset();
                    dialog.remove();
                    adminApp.app.trigger('detail', { type: 'users', username: name });
                }
            });
        });

        return {
            partial: true
        };
    };

    userRoutes.detail = function (params) {
        var userName = params.username;
        var table = null;
        var latestData;

        //Calculate if there are any added groups, if so we add them as the extra param 'n'
        //"Why n?" I hear you ask. Because thats what Alex coded and its stuck. I assume it means 'new'. Sorry.
        var potentialAddedGroups = params.potentialAddedGroups;
        var groupParam = {}; //If we don't have a blank to give it, it gets sad.
        if (potentialAddedGroups) {
            groupParam = { "n": potentialAddedGroups }
        }

        var userDetails = getUserDetails(userName).done(function (data) {
            data = $.extend({}, data, {
                dissociateDisabled: !data.aidAccount,
                isActive: data.active
            });
            latestData = data;

            helpers.updateContent(usermanagement.users.view(data));
            var $tableContainer = $('#user-memberships');
            table = new root.UMDataTable('groups', {
                container: $tableContainer,
                searchTriggerContainer: $tableContainer,
                parse: function (data) { return data.groups; },
                url: AJS.contextPath() + '/rest/um/1/user/group/direct',
                noResultsMessage: AJS.I18n.getText('usermanagement.users.groups.no.groups'),
                rowTemplate: usermanagement.groups.row_member_group,
                searchFilter: root.helpers.groups.groupSearchFilter,
                extraParams: groupParam,
                loadedCallback: function () {
                    helpers.tooltips();
                    //Find the table
                    table.highlightNewRows(function() { return $.inArray($(this).data("group"), potentialAddedGroups) > -1; });
                }
            });

            manipulation.groups.setupUserRemovalFromGroup({
                table: table.getTableElement(),
                userName: userName,
                completed: function(groupName, userName) {
                    getUserDetails.reset(userName);
                    getApplicationWithSeats.reset();
                    adminApp.app.trigger("detail", { type: "users", username: userName });
                }
            });

            $('#add-group-button').click(function(event) {
                event.preventDefault();
                var dialog = new root.UMModal({
                    height: 200,
                    template: usermanagement.users.addGroup({
                        name: userName
                    }),
                    title:  AJS.I18n.getText('usermanagement.users.groups.add.title'),
                    submitButton: AJS.I18n.getText('usermanagement.users.groups.add')
                });

                var $parentGroup = $("#parentGroup");

                var groupPicker = helpers.groups.setupGroupPicker({
                    $element: $parentGroup,
                    multiple: true,
                    autoFocus: true
                });

                var UMFormOptions = {
                    dataFormatter: function(data) {
                        data.groups = [];
                        $.each(groupPicker.getGroups(), function(index, group){
                            data.groups.push({'name': group.id});
                        });
                        return data;
                    }
                };

                new root.UMForm('#user-add-group', 'POST', UMFormOptions)
                    .on('done', function(data) {
                        potentialAddedGroups = $.map(data.groups, function(group) { return group.name; });

                        getUserDetails.reset(userName);
                        getApplicationWithSeats.reset();
                        dialog.remove();

                        //Now we trigger a mini-refresh to update licence counts, get flash messages etc
                        adminApp.app.trigger("detail", { type: "users", username: userName, potentialAddedGroups: potentialAddedGroups });
                    });

                helpers.select2.resizeModalBasedOnHeight($parentGroup, dialog);
            });
            return data;
        }).fail(function (xhr) {
            helpers.updateContent(AJS.messages.error({
                body: _.escape(JSON.parse(xhr.responseText).errors[0].message),
                closeable: false
            }));
        });

        function userUpdated(message) {
            flag({
                type: "success",
                close: 'auto',
                body: message
            });
            adminApp.app.trigger('detail', { type: 'users', username: userName });
        }

        //This is the call to get the licence and application info. Should only redraw parts of the screen once the user detail shell is done
        $.when(userDetails, helpers.ajax.getLicenseUsage()).done(function (userDetailsData, licenseUsage) {
            var apps = licenseUsage.products;
            latestData = $.extend(latestData, {
                applications: formatApplications({
                    applications: apps,
                    autoUpgradeMode: licenseUsage.autoUpgradeMode,
                    accessLevels: userDetailsData.accessLevels,
                    disableAll: (latestData.unmodifiableMemberships || latestData.isSelf),
                    hideLicenceDetails: true,
                    isUserActive: userDetailsData.active
                })
            });

            //Pop in app access checkboxes
            $('div#application-checkboxes').replaceWith(usermanagement.users.generateAppAccessHtml(latestData));

            //if the instance has JIRA, show the dropdown for JIRA user properties
            if (_.contains(_.pluck(apps, "description"), "JIRA")) {
                var dropdownButton = aui.buttons.button({
                    id: 'edit-user-button-dropdown',
                    text: '&nbsp;',
                    splitButtonType: 'more',
                    dropdown2Target: 'edit-dropdown'
                });

                $('#change-password-button').parent().append(dropdownButton);
            }


            $('.view-user-applications input.checkbox').on('change', function () {
                var $this = $(this);
                var $form = $('.view-user-applications');

                var method;
                var options = {};
                var successMessage;
                var errorMessage;
                options.insertErrorsAutomagically = false; //We deal with it manually by throwing a flag

                var applicationName = AJS.I18n.getText('usermanagement.apps.selected.application'); // theoretically not needed, as $this.val() came from data.applications
                $.each(latestData.applications, function(i, application) {
                    if (application.id === $this.val()) {
                        applicationName = application.applicationName;
                    }
                });

                if ($this.is(':checked')) {
                    method = 'POST';
                    options.dataFormatter = function () {
                        return {
                            productIds: [ $this.val() ],
                            users: [ userName ]
                        };
                    };
                    successMessage = AJS.I18n.getText('usermanagement.apps.user.granted.access.to.product', userName, applicationName);
                    errorMessage = AJS.I18n.getText('usermanagement.apps.user.granted.access.to.product.error', userName, applicationName);
                } else {
                    method = 'DELETE';
                    $form.attr('action', $form.attr('action') + '&productId=' + $this.val());
                    successMessage = AJS.I18n.getText('usermanagement.apps.user.revoked.access.to.product', userName, applicationName);
                    errorMessage = AJS.I18n.getText('usermanagement.apps.user.revoked.access.to.product.error', userName, applicationName);
                }

                $this.closest('.group').find('input.checkbox').attr('disabled', 'disabled');

                new root.UMForm($form, method, options)
                    .on('done', function(data) {
                        if (!data || (data.completed[$this.val()] !== undefined && ~data.completed[$this.val()].successes.indexOf(userName))) {
                            getUserDetails.reset(userName);
                            getApplicationWithSeats.reset();
                            userUpdated.call(this, successMessage);
                        } else {
                            if (data && data.licenseExceeded[$this.val()] !== undefined) {
                                var exceeded = data.licenseExceeded[$this.val()];
                                if (exceeded.available >= 0) {
                                    errorMessage = AJS.I18n.getText('usermanagement.apps.license.exceeded.error', applicationName, exceeded.needed, exceeded.available);
                                } else {
                                    errorMessage = AJS.I18n.getText('usermanagement.apps.license.exceeded.error.negative.seats', applicationName, -1 * exceeded.available, exceeded.needed);
                                }
                            } else if (data && data.aborted[$this.val()] !== undefined) {
                                errorMessage = data.aborted[$this.val()];
                            }
                            getUserDetails.reset(userName);
                            getApplicationWithSeats.reset();
                            flag({
                                type: "error",
                                body: errorMessage
                            });

                            adminApp.app.trigger('detail', { type: 'users', username: userName });
                        }
                    }).on('fail', function(data){
                        var flagErrorMessage;
                        if (data.responseJSON && data.responseJSON.errors && data.responseJSON.errors.length) {
                            flagErrorMessage = data.responseJSON.errors[0].message;
                        } else {
                            flagErrorMessage = errorMessage; //use the generic fail message determined earlier
                        }

                        flag({
                            type: "error",
                            body: flagErrorMessage
                        });

                        adminApp.app.trigger('detail', { type: 'users', username: userName });
                    });

                $form.submit();
            });
        });

        return {
            events: {
                'click #edit-user-button': function (e) {
                    e.preventDefault();
                    adminApp.app.trigger("edit", { type: "users", username: userName });
                },
                'click #dissociate-link': function (e) {
                    if ($(e.target).attr('aria-disabled')) {
                        //The link is disabled, but the css doesn't work in IE. Quit here.
                        return false;
                    }
                    e.preventDefault();
                    var dialog = new root.UMModal({
                        id: "dissociate-AID-confirmation-dialog",
                        template:  AJS.I18n.getText('usermanagement.users.AID.dissociate.confirmation.desc'),
                        title:  AJS.I18n.getText('usermanagement.users.AID.dissociate.confirmation.title'),
                        submitButton: AJS.I18n.getText('usermanagement.users.AID.dissociate.confirmation.button'),
                        onSubmit: function () {
                            $.ajax({
                                type: 'DELETE',
                                url: AJS.contextPath() + '/rest/um/1/user/AID?username=' + encodeURIComponent(userName)
                            }).done(function () {
                                flag({
                                    type: "success",
                                    close: 'auto',
                                    body: AJS.I18n.getText('usermanagement.users.AID.dissociate.success')
                                });
                                getUserDetails.reset(userName);
                            }).fail(function () {
                                flag({
                                    type: "error",
                                    body: AJS.I18n.getText('usermanagement.users.AID.dissociate.error')
                                });
                            }).always(function () {
                                dialog.remove();
                                adminApp.app.trigger('detail', { type: 'users', username: userName });
                            });
                        }
                    });
                },
                'click #change-password-button': function(e) {
                    e.preventDefault();
                    $.when(getUserDetails(userName), getPasswordPolicy()).done(function (data, policy) {
                        _.extend(data, {
                            policyScore: policy
                        });

                        var dialog = new root.UMModal({
                            height: 260,
                            template: usermanagement.users.change_password(data),
                            title:  AJS.I18n.getText('usermanagement.users.change.password.title'),
                            submitButton: AJS.I18n.getText('usermanagement.users.change.password.button')
                        });

                        var changePasswordForm = new root.UMForm("#user-change-password", "PUT").on("done", function () {
                            dialog.remove();
                            userUpdated.call(this, AJS.I18n.getText("usermanagement.users.success.password.changed", userName));
                        });

                        // Make sure that the infoMessage disappears when the dialog gets removed
                        AJS.bind("remove.dialog",function(e,data){
                            $(".aui-form-notification-tooltip").hide();
                        });

                        // Make sure that the infoMessage disappears when the window is resized, This is because
                        // the dialog box will adjust to be in the center, but the infoMessage won't follow it.
                        AJS.$(window).resize(function(){
                            $(".aui-form-notification-tooltip").hide();
                        });

                        root.password.PasswordMeter.addToForm({
                            context: '#user-change-password',
                            inputSelector: '#value',
                            addValidationTo: changePasswordForm
                        });
                        dialog.updateHeight();
                    });
                },
                'click .aui-nav-pagination': function (e) {
                    table.paginationEvent(e);
                },
                'click #delete-user-button': function () {
                    if (!adminApp.isFeatureEnabled("um.disable.user")) {
                        //If disable is being used, then delete is now a link not a button
                        adminApp.app.navigate('delete', {type: 'users', username: userName});
                    }
                },
                'click #change-user-active-button' : function (e) {
                    //Disable the button, call the action, then display a message and reload the page
                    //we reload the page to refresh lozenge/text, grey'd outness of apps and the buttons themselves

                    var button = $(e.target);
                    button.prop('disabled', true);
                    getUserDetails.reset(userName); //kill the cache so it gets the lozenge next time

                    if (button.data('user-state')) {
                        deactivateUser(userName).done(function () {
                            var inactiveLozenge = {
                                name: AJS.I18n.getText('usermanagement.users.lozenge.text.deactive'),
                                title: AJS.I18n.getText('usermanagement.users.lozenge.description.deactive'),
                                type: 'DEACTIVE'
                            }
                            helpers.updateContent(usermanagement.users.viewInnerHeader(_.extend(latestData, {isActive: false, lozenge: inactiveLozenge })), {selector: "#user-detail-header"});

                            flag({
                                type: "success",
                                close: 'auto',
                                body: AJS.I18n.getText("usermanagement.users.deactivate.success.message", userName)
                            });
                        }).fail(function () {
                            //if the previous ones failed, re-enable the button
                            button.prop('disabled', false);
                        });
                    } else {
                        $('#edit-user-button').parent().before(usermanagement.loading()); //only show for activate, since it is slow
                        activateUser(userName).done(function () {
                            helpers.updateContent(usermanagement.users.viewInnerHeader(_.extend(latestData, {isActive: true, lozenge: null})), {selector: "#user-detail-header"});
                            flag({
                                type: "success",
                                close: 'auto',
                                body: AJS.I18n.getText("usermanagement.users.activate.success.message", userName)
                            });
                        }).fail(function () {
                            //if the previous ones failed, re-enable the button
                            button.prop('disabled', false);
                            $('#edit-user-button').parent().parent().find('.aui-icon-wait').remove();
                        });
                    }
                }
            }
        }
    };

    var initHelpDialogs = function() {
        require("helpers/helptip")({
            anchor: "#bitbucket-help",
            body: usermanagement.bitbucket.helptip(),
            hideDelay: null,
            offsetX: -100,
            onHover: true
        });
    };
    
    userRoutes.add = function () {
        var mostRecentUserNamePopulated = "";
        var autoPopulationEnabled = true;
        var addUserForm;
        var recentLicenceUsage
        helpers.updateContent(usermanagement.users.addPrefetch());

        var pageLoaded = $.when(helpers.ajax.getApplicationsDescription(), getPasswordPolicy()).done(function (apps, policyScore) {

            helpers.updateContent(usermanagement.users.edit({
                action: AJS.contextPath() + "/rest/um/1/user",
                warnings: [],
                expiryDays: +localStorage[INVITE_EXPIRY_STORAGE_KEY] || DEFAULT_INVITE_EXPIRY,
                policyScore: policyScore
            }));

            $("[autofocus]").focus();

            $("#page-data").find("#create-another")
                .prop('checked', sessionStorage[CREATE_ANOTHER_STORAGE_KEY] === "true")
                .change(function () {
                    sessionStorage[CREATE_ANOTHER_STORAGE_KEY] = this.checked;
                });

            addUserForm = new root.UMForm("#user-edit-add", "POST", {
                insertErrorsAutomagically: true,
                dataFormatter: createDataFormatter(apps),
                presubmitValidator: function (validation) {
                    var sendNotification = $("#sendNotification");
                    var password = $("#password");
                    //If we aren't sending a notification, ensure a password is set
                    if (sendNotification[0] && !sendNotification.is(':checked') && !password.val()) {
                        validation.addFieldError("password", AJS.I18n.getText('usermanagement.users.password.empty'));
                    }
                    //If we are sending a notification, unset any potential passwords.
                    if (sendNotification[0] && sendNotification.is(':checked')) {
                        password.val('');
                    }
                }
            }).on("done", function (data) {
                userRoutes.messages.displayUserSuccessfullyAddedMessage({
                    isAutoUpgradeModeEnabled: recentLicenceUsage.autoUpgradeMode.enabled,
                    oldLicenseUsages: recentLicenceUsage.products,
                    emailSent: $("#sendNotification").is(':checked'),
                    user: data
                }).then(function () {
                    getApplicationWithSeats.reset(); // More than likely seat counts have changed after creating user

                    if (sessionStorage[CREATE_ANOTHER_STORAGE_KEY] === "true") {
                        adminApp.app.trigger('add', { type: 'users' });
                    } else {
                        adminApp.app.navigate('detail', { type: 'users', username: data.name });
                    }
                });
            }).on('always', function () {
                localStorage[INVITE_EXPIRY_STORAGE_KEY] = addUserForm._formData().fields.expiryDays;
            });

            root.password.PasswordMeter.addToForm({
                context: '#user-edit-add',
                inputSelector: '#password',
                addValidationTo: addUserForm,
                allowEmpty: true // empty is sometimes valid here--use a custom validator
            });
        });

        $.when(pageLoaded, helpers.ajax.getLicenseUsage()).done(function(ignore, licenceUsage) {
            $('#submit-button').attr('aria-disabled', false).prop('disabled', false).removeAttr('title');

            recentLicenceUsage = licenceUsage;
            var apps = licenceUsage.products;
            apps = formatApplications({
                applications: apps,
                autoUpgradeMode: licenceUsage.autoUpgradeMode,
                hideLicenceDetails: licenceUsage.autoUpgradeMode && licenceUsage.autoUpgradeMode.enabled
            });

            $('#application-checkboxes').replaceWith(aui.form.checkboxField({
                fields: apps,
                extraClasses: 'field-group',
                legendContent: AJS.I18n.getText('usermanagement.users.application.access')
            }));

            root.ApplicationCheckboxController.configureApplicationCheckboxRelationships(licenceUsage, '.field-group');

            getBitbucketConfiguration(licenceUsage.products).done(function($config) {
                if ($config) {
                    var $buttonsContainer = $('#user-edit-add').children('.buttons-container');
                    $config.insertBefore($buttonsContainer);
                    initHelpDialogs();
                }
            }).fail(function() {
                showBitbucketFlag();
            });
        });

        return {
            events: {
                'change #sendNotification': function () {
                    $('.passwords').toggle();
                    $('#password').val('');
                    $("#expiryDays").prop("disabled", !this.checked);
                },
                'input #email': function () {
                    if (autoPopulationEnabled) {
                        var userName = mostRecentUserNamePopulated = this.value.split("@")[0];
                        $('#name').val(userName);
                    }
                },
                'change #name': function () {
                    var userName = this.value;
                    if (userName !== mostRecentUserNamePopulated) {
                        autoPopulationEnabled = false;
                    }
                }
            },
            focusedTask: true
        }
    };

    userRoutes.invite = function () {
        var latestLicenceDetails;

        helpers.ajax.getLicenseUsage().done(function (licenceUsage) {
            latestLicenceDetails = licenceUsage;
            $('#submit-button').attr('aria-disabled', false).prop('disabled', false).removeAttr('title');

            var apps = formatApplications({
                applications: licenceUsage.products,
                autoUpgradeMode: licenceUsage.autoUpgradeMode,
                hideLicenceDetails: licenceUsage.autoUpgradeMode && licenceUsage.autoUpgradeMode.enabled
            });

            $('#application-checkboxes').replaceWith(aui.form.checkboxField({
                id: 'applications',
                legendContent: AJS.I18n.getText('usermanagement.users.application.access'),
                fields: apps
            }));

            root.ApplicationCheckboxController.configureApplicationCheckboxRelationships(licenceUsage, '#applications');

            getBitbucketConfiguration(licenceUsage.products).done(function($config) {
                if ($config) {
                    var $buttonsContainer = $('#user-create').children('.buttons-container');
                    $config.insertBefore($buttonsContainer);
                    initHelpDialogs();
                }
            }).fail(function() {
                showBitbucketFlag();
            });
        });

            helpers.updateContent(usermanagement.users.invite({
                expiryDays: +localStorage[INVITE_EXPIRY_STORAGE_KEY] || DEFAULT_INVITE_EXPIRY,
            }));

            var emailPicker = helpers.users.setupMultipleEmailPicker($("#emailAddresses"));

            var form = new root.UMForm('#user-create', 'POST', {
                dataFormatter: function (data) {
                    var appFilter = [];
                    if(latestLicenceDetails) {
                        appFilter = root.helpers.applicationDataMappers.filterFakeCheckedApplications(latestLicenceDetails.applications, latestLicenceDetails.products) || [];
                    }
                    return {
                        applications: appFilter,
                        emailAddresses: emailPicker.getEmails(),
                        expiryDays: +data.expiryDays,
                        text: data.text
                    };
                }
            }).on('done', function (newUsers) {
                userRoutes.messages.displayUserSuccessfullyAddedMessage({
                    isAutoUpgradeModeEnabled: latestLicenceDetails.autoUpgradeMode.enabled,
                    oldLicenseUsages: latestLicenceDetails.products,
                    emailSent: !!newUsers.length,
                    users: newUsers
                }).then(function () {
                    getApplicationWithSeats.reset(); // More than likely seat counts have changed after creating user
                    adminApp.app.navigate('list', { type: 'users', n: newUsers });
                });
            }).on('always', function () {
                localStorage[INVITE_EXPIRY_STORAGE_KEY] = form._formData().fields.expiryDays;
            });

        return {
            focusedTask: true
        };
    };

    userRoutes.resetpassword = function (params) {
        $.getJSON(AJS.contextPath() + '/rest/um/1/resetpassword', {
            username: params.username,
            directoryId: params.directoryId,
            token: params.token
        }).done(function (data) {
            if (data && data.invalidToken) {
                helpers.updateContent(usermanagement.users.resetPasswordError());
                return;
            }
            helpers.updateContent(usermanagement.users.resetPassword({
                name: params.username,
                display_name: data.displayName,
                email: data.email,
                directoryId: params.directoryId,
                token: params.token,
                policyScore: policyScoreFilter(data)
            }), {
                hideUserControls: true
            });

            var resetPasswordForm = new root.UMForm("#user-reset-password", "POST").on("done", function() {
                // Re-route to root of application for Indra to take over log in etc
                window.location = '/';
            });

            root.password.PasswordMeter.addToForm({
                context: '#user-reset-password',
                inputSelector: '#password',
                addValidationTo: resetPasswordForm,
                policyScore: data.policyScore.ranking
            });
        });

        return {
            focusedTask: true,
            anonymous: true
        }
    };

    userRoutes.changepassword = function (params) {
        var returnUrlUntrimmed = params.returnUrl || '';
        $.getJSON(AJS.contextPath() + '/rest/um/1/changepassword').done(function (data) {
            if (data.usernameValid) {
                var returnUrl = returnUrlUntrimmed.trim();
                if (returnUrl[0] !== "/" || returnUrl[1] === "/") {
                    returnUrl = "/"; //Potentially malicious, default to root
                }

                helpers.updateContent(usermanagement.users.changePassword({
                    name: data.username,
                    display_name: data.display,
                    email: data.email,
                    returnUrl: returnUrl,
                    policyScore: policyScoreFilter(data)
                }), {
                    hideUserControls: true
                });

                var changePasswordForm = new root.UMForm("#user-change-password", "POST").on("done", function () {
                    sessionStorage.passwordchanged = true;
                    window.location = returnUrl;
                });

                root.password.PasswordMeter.addToForm({
                    context: '#user-change-password',
                    inputSelector: '#new-password',
                    addValidationTo: changePasswordForm,
                    policyScore: data.policyScore.ranking
                });
            } else {
                helpers.updateContent(usermanagement.users.changePasswordError({ error: AJS.I18n.getText('usermanagement.users.change.password.invalid.user', data.username)}), {
                    hideUserControls: true
                });
            }
        }).fail(function () {
            helpers.updateContent(usermanagement.users.changePasswordError({error: AJS.I18n.getText('usermanagement.users.change.password.no.logged.in.user')}), {
                hideUserControls: true
            });
        });

        return {
            focusedTask: true,
            anonymous: true
        }
    };

    userRoutes["sign-up"] = function (params) {
        if (params.token) {
            $.getJSON(AJS.contextPath() + '/rest/um/1/signup', {
                token: params.token
            }).done(function (data) {
                helpers.updateContent(usermanagement.users.signUpWithToken({
                    token: params.token,
                    email: data.invitation.emailAddress,
                    policyScore: policyScoreFilter(data)
                }));

                // AUI Form Soy stuff currently doesn't have anything
                // to show the ADG help icon. Let's insert it with JS
                // for now. The space is required, otherwise it renders
                // too close to the input element.
                var $helpIcon = $(aui.icons.icon({ icon: "help" }));
                $helpIcon.attr("title", AJS.I18n.getText("usermanagement.users.sign.up.email.help.text")).tooltip({gravity: 'w'});
                $("#email").after($helpIcon).after(" ");

                var signUpForm = new root.UMForm("#user-edit-add", "POST", {
                    dataFormatter: createDataFormatter({})
                }).on("done", function () {
                    var name = this.find("[name='name']").val();
                    flag({
                        type: "success",
                        close: "auto",
                        body: AJS.I18n.getText("usermanagement.users.success.edited", name)
                    });
                    window.location = "/";
                });

                root.password.PasswordMeter.addToForm({
                    context: '#user-edit-add',
                    inputSelector: '#password',
                    addValidationTo: signUpForm,
                    policyScore: data.policyScore.ranking
                });
            }).fail(function (xhr) {
                helpers.updateContent(AJS.messages.error({
                    body: _.escape(JSON.parse(xhr.responseText).errors[0].message),
                    closeable: false
                }));
            });
        } else {
            helpers.updateContent(usermanagement.users.signUp({
                email: params.email
            }));

            $("[autofocus]").focus();

            showRecaptcha("captcha-container");

            new root.UMForm("#user-signup", "POST").on("done", function () {
                var email = $("#email").val();
                helpers.updateContent(usermanagement.users.signUpEmailSent({
                    email: email
                }));

                $("#resend-email").click(function (e) {
                    e.preventDefault();
                    adminApp.app.trigger('sign-up', { type: 'users', email: email });
                });
            }).on("fail", Recaptcha.reload);
        }

        return {
            focusedTask: true,
            anonymous: true,
            events: {
                "click #captcha-reload": function (e) {
                    e.preventDefault();
                    Recaptcha.reload();
                },
                "click #captcha-switch-audio": function (e) {
                    e.preventDefault();
                    Recaptcha.switch_type("audio");
                },
                "click #captcha-switch-image": function (e) {
                    e.preventDefault();
                    Recaptcha.switch_type("image")
                }
            }
        };
    };

    var getUserDetails = helpers.memoize(function(username) {
        return $.getJSON(AJS.contextPath() + '/rest/um/1/user', {
            username: username,
            expand: 'attributes'
        }).then(function (data) {
            return helpers.users.sanitiseAndMapUserData(data);
        });
    });

    var getPasswordPolicy = function(){
        return helpers.ajax.getPasswordPolicy().then(policyScoreFilter, silentFailureHandler);
    }
    
    var showBitbucketFlag = function() {
        flag({
            type: "warning",
            title: AJS.I18n.getText("usermanagement.bitbucket.error.jira"),
            body: '<a href="/secure/admin/ConfigureDvcsOrganizations!default.jspa">' + AJS.I18n.getText('usermanagement.bitbucket.help.linktext') + '</a>'
        });
    };
    
    var getBitbucketConfiguration = function(products) {
        var foundJira = false;
        for (var i = 0; i < products.length; i++) {
            var product = products[i];
            if (product.description === 'JIRA' || product.hostType === 'jira') {
                foundJira = true;
                break;
            }
        }

        if (!foundJira) {
            return new $.Deferred().resolve().promise();
        }

        return $.ajax({
            dataType: "json",
            url: '/rest/bitbucket/1.0/defaultgroups',
            error: function (errorObject) {
                AJS.log('Error talking to JIRA regarding Bitbucket: ', errorObject);
                /* ignore */
            }
        }).then(function (data) {
            // clean up (remove orgs with no selected groups)
            var cleanData = {};
            cleanData.groupsCount = data.groupsCount;
            cleanData.errors = data.errors;
            cleanData.organizations = [];
            if (cleanData.groupsCount > 0) {
                for (var i = 0; i < data.organizations.length; i++) {
                    var org = data.organizations[i];
                    var cleanOrg = {
                        name: org.name,
                        id: org.id,
                        organizationUrl: org.organizationUrl,
                        groups: []
                    };
                    for (var j = 0; j < org.groups.length; j++) {
                        var group = org.groups[j];
                        if (group.selected) {
                            cleanOrg.groups.push(group);
                        }
                    }
                    if (cleanOrg.groups.length) {
                        cleanData.organizations.push(cleanOrg);
                    }
                }
            }

            var $bitbucketConfig = null;
            if (data.errors.length) {
                $bitbucketConfig = $(usermanagement.bitbucket.genericConfiguration());
            } else if (cleanData.organizations.length > 0) {
                $bitbucketConfig = $(usermanagement.bitbucket.configuration({
                    config: cleanData
                }));
            }

            return $bitbucketConfig;
        });
    };

    var getApplicationWithSeats = helpers.memoize(helpers.ajax.getApplicationWithSeats);

    function createDataFormatter(productList) {
        return function (data) {
            var formatted = {};
            $.each(data, function (key, value) {
                if (key === 'password') {
                    if ($.trim(value)) {
                        formatted[key] = { value: value };
                    }
                } else if (key === 'applications') {
                    formatted[key] = root.helpers.applicationDataMappers.filterFakeCheckedApplications(value, productList);
                } else if (key === 'expiryDays') {
                    formatted[key] = +value;
                } else if (!~ignoredFields.indexOf(key)) {
                    formatted[key] = value;
                }
            });
            return formatted;
        }
    }

    /**
     * @param options.applications
     * @param options.autoUpgradeMode
     * @param [options.accessLevels]
     * @param [options.disableAll]
     * @param [options.hideLicenceDetails]
     * @param [options.isUserActive]
     */
    function formatApplications(options) {
        return $.map(helpers.applicationDataMappers.formatApplications(options), function (app) {
            // keep the actual application name separate so that we can reference it during modification
            app.applicationName = app.name;

            // AUI Checkbox uses the 'name' attribute to name checkboxes.
            // We want the checkboxes to be named 'applications' instead of the actual app name
            app.name = "applications";

            return app;
        });
    }

    userRoutes.sanitiseUserData = function (data) {
        return $.map(data, helpers.users.sanitiseAndMapUserData);
    };

    function activateUser (username) {
        return $.post(
            AJS.contextPath() + '/rest/um/1/user/activate?username=' + encodeURIComponent(username)
        ).fail(function (xhr) {
            try {
                var message = JSON.parse(xhr.responseText).errors[0].message;
                flag({
                    type: "error",
                    body: message
                });
            } catch(err) {
                flag({
                    type: "error",
                    body: AJS.I18n.getText("usermanagement.users.activate.error.message", username)
                });
            }
        }).complete(function () {
                $('button.activationButton[data-username="' + username + '"]').next('.aui-icon-wait').remove()
            });
    }

    function deactivateUser (username) {
        return $.post(
            AJS.contextPath() + '/rest/um/1/user/deactivate?username=' + encodeURIComponent(username)
        ).fail(function (xhr) {
            try {
                var message =  JSON.parse(xhr.responseText).errors[0].message;
                flag({
                    type: "error",
                    body: message
                });
            } catch(err) {
                flag({
                    type: "error",
                    body: AJS.I18n.getText("usermanagement.users.deactivate.error.message", username)
                });
            }
        }).complete(function () {
                $('button.activationButton[data-username="' + username + '"]').next('.aui-icon-wait').remove()
        });
    }

    /**
     * Checks that for each username provided, there is an email and that for each email, there is a username.
     * @param addErrorToField Function used to add an error to the current field.
     * @param current The field we are currently checking, username or email.
     * @param other The current field's paired username or email field
     */
    function checkPair(addErrorToField, current, other){
        _.each(current, function(cur, index){
            if (cur !== "") {
                if (other[index] === "") {
                    //nth current was provided but it's paired other was not
                    addErrorToField({fieldIndex: index});
                }
            }
        });
    }

    /**
     * Checks that for each field, if it has no content, all subsequent fields of that type must also have no content.
     * @param addErrorToField Function used to add an error to the skipped field
     * @param fieldSet Set of fields to check. Provided in DOM order.
     */
    function checkSubsequent(addErrorToField, fieldSet){
        var providedSwitch = true;
        _.each(fieldSet, function(current, index){
            if (current !== "" && !providedSwitch) {
                //nth field was provided but previous field was not
                addErrorToField({fieldIndex: index-1});
            } else if (current === "") {
                //this field was not provided, ensure subsequent fields are empty as well
                providedSwitch = false;
            }
        });
    }

    function policyScoreFilter(policy){
        return {
            name: AJS.I18n.getText('usermanagement.passwordpolicy.names.' + policy.policyScore.name).toLowerCase(),
            ranking: policy.policyScore.ranking
        }
    }

    /**
     * A failure handler which will return a new promise object with nothing in it.
     */
    function silentFailureHandler(){
        var newDeferred = $.Deferred();
        newDeferred.resolve();
        return newDeferred.promise();
    }

}(AJS.$, window.UserManagement = window.UserManagement || {}, window.adminApp));

