(function ($, root) {
    //constants that are useful application wide.
    root.helpers = root.helpers || {};
    var userControlsSelector = '[aria-owns="user-dropdown"],[aria-owns="admin-dropdown"]';

    root.helpers.updateContent = function (html, options) {
        options = $.extend({}, options);
        // There is a time where the user controls (currently in top right of top bar)
        // shouldn't be visible.
        $(userControlsSelector).toggle(!options.hideUserControls);
        var $pageContent = options.selector ? $(options.selector) : $('#page-data');
        $pageContent.children().remove();
        return $pageContent.append(html);
    };

    //Create a function which tells us whether or not updateContent was called since this function was created.
    root.helpers.checkContentUpdated = function(){
        var contentUpdated = false;
        var updateContent = root.helpers.updateContent;

        root.helpers.updateContent = function(){
            contentUpdated = true;
            updateContent.apply(this, arguments);
        };

        return function(){
            root.helpers.updateContent = updateContent;
            return contentUpdated;
        }
    };

})(AJS.$, window.UserManagement = window.UserManagement || {});
