define("helpers/helptip", ['jquery'], function ($) {
    /**
     * @module helptip
     */

    /**
     * @constructor
     * @param {object} attrs
     * @param {string} attrs.anchor - selector of element to anchor to
     * @param {string} attrs.body - the HTML body content of the helptip
     * @param {string} attrs.noBind - will not bind a click handler to the anchor and prevent default if true
     */
    return function (attrs) {
        var dialog = AJS.InlineDialog(attrs.anchor, undefined, function (content, trigger, show) {
            content.html(attrs.body).find(".helptip-close").click(function () {
                dialog.hide();
            });
            show();
        }, attrs);
        if (attrs.noBind) {
            $(attrs.anchor).click(function () {
                dialog.hide();
            });
        }
        return dialog;
    };
});
