(function($){
    var appAdminPath = {
        "applinks.jira": "/secure/project/ViewProjects.jspa",
        "applinks.confluence": "/admin/console.action",
        "applinks.bamboo": "/admin/administer.action"
    };

    //We only need to draw applinks once. This function redefines itself to a noop after it's work is done.
    var drawApplinks = function () {
        $.getJSON(AJS.contextPath() + '/rest/um/1/applinks').done(function (applinks) {
            var $navLinks = $('.nav-links'),
                $appAdmin = $('#app-admin');
            $.each(applinks, function (i, applink) {
                $navLinks.append(adminApp.appswitcher.app({
                    name: applink.name,
                    displayUrl: applink.displayUrl
                }));
                $appAdmin.append(adminApp.appswitcher.appAdmin({
                    name: applink.name,
                    displayUrl: applink.displayUrl + appAdminPath[applink.type]
                }));
            });
        }).fail(function () {
            $('.app-switcher-trigger').removeAttr('aria-haspopup aria-owns');
        });
        drawApplinks = $.noop;
    };

    var crowdFilter = function(routeData) {
        if (routeData.anonymous) {
            $(".aui-header-before, .aui-header-secondary").remove();
            $("#logo").find("a").attr("href", "/");
        } else {
            drawApplinks();
        }
        return routeData;
    };
    Doppelganger.setFilterHandler('CrowdFilter', crowdFilter);
})(AJS.$);
