/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.util;

import com.atlassian.crowd.plugin.usermanagement.rest.exception.LicenseExceededException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ProductAccessErrorException;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.service.validation.Failure;
import com.atlassian.crowd.plugin.usermanagement.service.validation.LicenseExceeded;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ProductAccessError;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.util.ImmutableMapUtils;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Eithers;
import com.atlassian.fugue.Functions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class FailureUtils {
    private FailureUtils() {
        throw new UnsupportedOperationException();
    }

    public static <R> Map<Product, R> handleMaybeFailures(Map<Product, Either<Failure, R>> result) throws LicenseExceededException {
        ImmutableMap failures = ImmutableMapUtils.collectByValue(result, Eithers.leftMapper());
        FailureUtils.handleFailures(failures);
        return ImmutableMapUtils.collectByValue(result, Eithers.rightMapper());
    }

    public static <R> R handleMaybeFailures(Either<Map<Product, Failure>, R> result) throws LicenseExceededException {
        if (result.isLeft()) {
            FailureUtils.handleFailures((Map)result.left().get());
        }
        return result.right().get();
    }

    public static void handleFailures(Map<Product, Failure> failures) throws LicenseExceededException {
        if (failures.size() > 0) {
            ImmutableMap<Product, ProductAccessError> accessErrors = ImmutableMapUtils.collectByValue(failures, Functions.isInstanceOf(ProductAccessError.class));
            if (accessErrors.size() > 0) {
                throw new ProductAccessErrorException((Map<Product, ProductAccessError>)accessErrors);
            }
            ImmutableMap<Product, LicenseExceeded> licenseErrors = ImmutableMapUtils.collectByValue(failures, Functions.isInstanceOf(LicenseExceeded.class));
            if (licenseErrors.size() > 0) {
                throw new LicenseExceededException((Map<Product, LicenseExceeded>)licenseErrors);
            }
            throw new RuntimeException("There are unhandled failures beside ApplicationAccessError and LicenseExceeded: " + failures);
        }
    }
}

