/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity;

import com.atlassian.crowd.plugin.usermanagement.userprovisioning.AccessLevel;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.GroupAttributesEntity;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class PermissionEntity {
    @JsonProperty
    private final Map<String, GroupAttributesEntity> groups;
    @JsonProperty
    private final List<String> users;

    @JsonCreator
    public PermissionEntity(@JsonProperty(value="groups") Map<String, GroupAttributesEntity> groups, @JsonProperty(value="users") List<String> users) {
        this.groups = groups;
        this.users = users;
    }

    public Map<String, GroupAttributesEntity> getGroups() {
        return this.groups;
    }

    public List<String> getUsers() {
        return this.users;
    }

    public static PermissionEntity newEmpty() {
        return new PermissionEntity((Map<String, GroupAttributesEntity>)ImmutableMap.of(), (List<String>)ImmutableList.of());
    }

    public static Map<String, GroupAttributesEntity> getGroupPermissions(Map<AccessLevel, PermissionEntity> permissions, AccessLevel level) {
        PermissionEntity entity;
        if (permissions != null && (entity = permissions.get((Object)level)) != null) {
            return ImmutableMap.copyOf(entity.getGroups());
        }
        return ImmutableMap.of();
    }

    public static Set<String> getGroups(Map<AccessLevel, PermissionEntity> permissions, AccessLevel level) {
        PermissionEntity entity;
        if (permissions != null && (entity = permissions.get((Object)level)) != null) {
            return ImmutableSet.copyOf(entity.getGroups().keySet());
        }
        return ImmutableSet.of();
    }

    public static Set<String> getDefaultGroups(Map<AccessLevel, PermissionEntity> permissions, AccessLevel level) {
        PermissionEntity entity;
        if (permissions != null && (entity = permissions.get((Object)level)) != null) {
            final Map<String, GroupAttributesEntity> groups = entity.getGroups();
            Set filtered = Sets.filter(groups.keySet(), (Predicate)new Predicate<String>(){

                public boolean apply(@Nullable String input) {
                    return groups.containsKey(input) && ((GroupAttributesEntity)groups.get(input)).isDefault();
                }
            });
            return ImmutableSet.copyOf((Collection)filtered);
        }
        return ImmutableSet.of();
    }
}

