/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.userprovisioning.config;

import com.atlassian.crowd.plugin.usermanagement.userprovisioning.AccessLevel;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.config.CrowdAttributeFormat;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.config.CrowdAttributesService;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.GroupAttributesEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.PermissionEntity;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CrowdPermissionAdapter {
    private final CrowdAttributesService attributesService;

    public CrowdPermissionAdapter(CrowdAttributesService attributesService) {
        this.attributesService = attributesService;
    }

    public Map<AccessLevel, PermissionEntity> fetchPermissions(String hostId, String productKey, boolean includeAdminPermissions) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)AccessLevel.USE, (Object)this.fetchUsePermissions(hostId, productKey));
        builder.put((Object)AccessLevel.ADMIN, (Object)this.fetchAdminPermissions(hostId));
        builder.put((Object)AccessLevel.SYSADMIN, (Object)this.fetchSysAdminPermissions(hostId));
        return builder.build();
    }

    public PermissionEntity fetchUsePermissions(String hostId, String productKey) {
        Set<String> useGroups = this.attributesService.getGroupsWithAttribute(CrowdAttributeFormat.generateUse(hostId, productKey));
        Set<String> defaultUseGroups = this.attributesService.getGroupsWithAttribute(CrowdAttributeFormat.generateDefaultUse(hostId, productKey));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String useGroup : useGroups) {
            builder.put((Object)useGroup, (Object)new GroupAttributesEntity(defaultUseGroups.contains(useGroup)));
        }
        return new PermissionEntity((Map<String, GroupAttributesEntity>)builder.build(), (List<String>)ImmutableList.of());
    }

    public PermissionEntity fetchAdminPermissions(String hostId) {
        Set<String> adminGroups = this.attributesService.getGroupsWithAttribute(CrowdAttributeFormat.generateAdmin(hostId));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String adminGroup : adminGroups) {
            builder.put((Object)adminGroup, (Object)new GroupAttributesEntity(false));
        }
        return new PermissionEntity((Map<String, GroupAttributesEntity>)builder.build(), (List<String>)ImmutableList.of());
    }

    public PermissionEntity fetchSysAdminPermissions(String hostId) {
        Set<String> sysAdminGroups = this.attributesService.getGroupsWithAttribute(CrowdAttributeFormat.generateSysAdmin(hostId));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String adminGroup : sysAdminGroups) {
            builder.put((Object)adminGroup, (Object)new GroupAttributesEntity(false));
        }
        return new PermissionEntity((Map<String, GroupAttributesEntity>)builder.build(), (List<String>)ImmutableList.of());
    }

    public void writeUsePermissions(String hostId, String productKey, PermissionEntity entity) {
        if (entity != null && entity.getGroups() != null) {
            Map<String, GroupAttributesEntity> groupPermissions = entity.getGroups();
            for (String group : groupPermissions.keySet()) {
                this.attributesService.addAttribute(group, CrowdAttributeFormat.generateUse(hostId, productKey));
                if (!groupPermissions.get(group).isDefault()) continue;
                this.attributesService.addAttribute(group, CrowdAttributeFormat.generateDefaultUse(hostId, productKey));
            }
        }
    }

    public boolean writeUnapprovedUsePermissions(String hostId, String productKey, PermissionEntity entity) {
        boolean modified = false;
        Set<String> groupsWithUse = this.attributesService.getGroupsWithAttribute(CrowdAttributeFormat.generateUse(hostId, productKey));
        if (entity != null && entity.getGroups() != null) {
            Map<String, GroupAttributesEntity> groupPermissions = entity.getGroups();
            for (String group : groupPermissions.keySet()) {
                if (groupsWithUse.contains(group)) continue;
                this.attributesService.addAttribute(group, CrowdAttributeFormat.generateUnapprovedUse(hostId, productKey, false));
                if (groupPermissions.get(group).isDefault()) {
                    this.attributesService.addAttribute(group, CrowdAttributeFormat.generateUnapprovedUse(hostId, productKey, true));
                }
                modified = true;
            }
        }
        return modified;
    }

    public void writeAdminPermissions(String hostId, PermissionEntity entity) {
        if (entity != null && entity.getGroups() != null) {
            Map<String, GroupAttributesEntity> groupPermissions = entity.getGroups();
            for (String group : groupPermissions.keySet()) {
                this.attributesService.addAttribute(group, CrowdAttributeFormat.generateAdmin(hostId));
            }
        }
    }

    public boolean writeUnapprovedAdminPermissions(String hostId, PermissionEntity entity) {
        boolean modified = false;
        if (entity != null && entity.getGroups() != null) {
            Set<String> groupsWithAdmin = this.attributesService.getGroupsWithAttribute(CrowdAttributeFormat.generateAdmin(hostId));
            Map<String, GroupAttributesEntity> groupPermissions = entity.getGroups();
            for (String group : groupPermissions.keySet()) {
                if (groupsWithAdmin.contains(group)) continue;
                this.attributesService.addAttribute(group, CrowdAttributeFormat.generateUnapprovedAdmin(hostId));
                modified = true;
            }
        }
        return modified;
    }

    public void writeSysAdminPermissions(String hostId, PermissionEntity entity) {
        if (entity != null && entity.getGroups() != null) {
            Map<String, GroupAttributesEntity> groupPermissions = entity.getGroups();
            for (String group : groupPermissions.keySet()) {
                this.attributesService.addAttribute(group, CrowdAttributeFormat.generateSysAdmin(hostId));
            }
        }
    }

    public void clearAllPermissions(String hostId, Set<String> productKeys) {
        this.clearAttributes(CrowdAttributeFormat.generateAdmin(hostId));
        this.clearAttributes(CrowdAttributeFormat.generateSysAdmin(hostId));
        this.clearUsePermissions(hostId, productKeys);
    }

    public void clearUsePermissions(String hostId, Set<String> productKeys) {
        for (String productKey : productKeys) {
            this.clearAttributes(CrowdAttributeFormat.generateUse(hostId, productKey));
            this.clearAttributes(CrowdAttributeFormat.generateDefaultUse(hostId, productKey));
        }
    }

    private void clearAttributes(String attribute) {
        Set<String> adminGroups = this.attributesService.getGroupsWithAttribute(attribute);
        this.attributesService.removeAttribute(adminGroups, attribute);
    }
}

