/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.task;

import com.atlassian.crowd.plugin.usermanagement.service.ApplicationLinkFilteringService;
import com.atlassian.crowd.plugin.usermanagement.service.ProductService;
import com.atlassian.crowd.plugin.usermanagement.service.UserProvisioningService;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.fugue.Iterables;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialiseDefaultProductsTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitialiseDefaultProductsTask.class);
    private final UserProvisioningService provisioningService;
    private final ApplicationLinkFilteringService applicationLinkFilteringService;
    private final PluginSettings globalSettings;
    private final ProductService productService;
    protected static final String INITIALISED = "atlassian.usermanagement.initialised.default.apps";

    public InitialiseDefaultProductsTask(UserProvisioningService provisioningService, ApplicationLinkFilteringService applicationLinkFilteringService, PluginSettingsFactory pluginSettingsFactory, ProductService productService) {
        this.provisioningService = provisioningService;
        this.applicationLinkFilteringService = applicationLinkFilteringService;
        this.globalSettings = pluginSettingsFactory.createGlobalSettings();
        this.productService = productService;
    }

    @PostConstruct
    public void onStart() {
        boolean initialised;
        boolean bl = initialised = this.globalSettings.get(INITIALISED) != null;
        if (!initialised) {
            LOGGER.info("Initialising default products");
            HashMap<Product, Boolean> defaults = new HashMap<Product, Boolean>();
            List<Product> products = this.productService.fetchProducts();
            if (Iterables.isEmpty().apply(this.provisioningService.getDefaultProducts(products))) {
                for (Product product : products) {
                    LOGGER.info("Adding " + product.getProductName() + " as default product");
                    defaults.put(product, true);
                }
                this.provisioningService.updateProductDefaults(defaults);
            }
            this.globalSettings.put(INITIALISED, (Object)"true");
            LOGGER.info("Default products initialised");
        }
    }
}

