/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service.validation;

import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.ValidationMessageEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.ValidationResultEntity;
import com.atlassian.sal.api.message.Message;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ValidationResults {
    private final List<Message> errors;
    private final Map<ReadOnlyApplicationLink, ValidationResultEntity> applicationValidationResults;

    public ValidationResults(Collection<Message> errors, Map<ReadOnlyApplicationLink, ValidationResultEntity> applicationValidationResults) {
        this.errors = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(errors)));
        this.applicationValidationResults = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(applicationValidationResults)));
    }

    private static Map<ReadOnlyApplicationLink, ValidationResultEntity> emptyApplicationResults() {
        return Collections.emptyMap();
    }

    public static ValidationResults errorResult(Message errorMessage) {
        return new ValidationResults(Collections.singleton(errorMessage), ValidationResults.emptyApplicationResults());
    }

    public static ValidationResults applicationValidationResults(Map<ReadOnlyApplicationLink, ValidationResultEntity> applicationValidationResults) {
        return new ValidationResults(Collections.emptyList(), applicationValidationResults);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty() || Iterables.any(this.applicationValidationResults.values(), ValidationResultEntity.HAS_ERROR_PREDICATE);
    }

    public Map<ReadOnlyApplicationLink, ValidationResultEntity> getApplicationValidationResults() {
        return this.applicationValidationResults;
    }

    public List<Message> getGenericErrors() {
        return this.errors;
    }

    public Iterable<ValidationMessageEntity> getApplicationErrors() {
        return Iterables.concat((Iterable)Iterables.transform(this.applicationValidationResults.values(), ValidationResultEntity.GET_ERRORS));
    }
}

