/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service.validation;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.plugin.usermanagement.service.UserProvisioningService;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.service.validation.Failure;
import com.atlassian.fugue.Option;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.util.Set;

public abstract class LicenseCheckFunction<F extends Failure>
implements Function<Product, Option<F>> {
    protected final UserProvisioningService userProvisioningService;

    public LicenseCheckFunction(UserProvisioningService userProvisioningService) {
        this.userProvisioningService = userProvisioningService;
    }

    public Option<F> apply(Product product) {
        if (!product.hasProductConfig().booleanValue()) {
            return Option.none();
        }
        Option<Integer> potentialSeatsAvailable = this.getSeatsAvailable(product);
        if (potentialSeatsAvailable.isEmpty()) {
            return Option.none();
        }
        int seatsAvailable = (Integer)potentialSeatsAvailable.get();
        Set<String> usersGainingLicenseSeat = this.getAllUsersGainingLicenseSeat(product);
        int seatsRequired = usersGainingLicenseSeat.size();
        if (seatsRequired > Math.max(seatsAvailable, 0)) {
            return this.buildError(product, usersGainingLicenseSeat, seatsRequired, seatsAvailable);
        }
        return Option.none();
    }

    private Set<String> getAllUsersGainingLicenseSeat(Product product) {
        try {
            Set<String> usersPotentiallyGainingAccess = this.getUsersPotentiallyGainingLicenseSeat(product);
            if (usersPotentiallyGainingAccess.isEmpty()) {
                return usersPotentiallyGainingAccess;
            }
            Set<String> allUsersWhoCurrentlyHaveAccess = this.userProvisioningService.findUsernamesGrantedAccessToProduct(product);
            Object usersGainingLicenseSeat = Sets.difference(usersPotentiallyGainingAccess, allUsersWhoCurrentlyHaveAccess);
            usersGainingLicenseSeat = this.userProvisioningService.filterOutInactiveUsers((Set<String>)usersGainingLicenseSeat);
            Set<String> allUsersExcludedFromLicenseCount = this.userProvisioningService.findUsernamesExcludedFromLicenseCount(product);
            usersGainingLicenseSeat = Sets.difference((Set)usersGainingLicenseSeat, allUsersExcludedFromLicenseCount);
            return usersGainingLicenseSeat;
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            throw new RuntimeException(e);
        }
    }

    private Option<Integer> getSeatsAvailable(Product product) {
        try {
            return this.userProvisioningService.getAvailableSeatsForProduct(product);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            return Option.none();
        }
    }

    protected abstract Set<String> getUsersPotentiallyGainingLicenseSeat(Product var1);

    protected abstract Option<F> buildError(Product var1, Set<String> var2, int var3, int var4);
}

