/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service.products;

import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.host.HostEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.host.HostProductEntity;
import com.atlassian.util.license.LicensedApplicationSource;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;

public final class ProductUtils {
    public static final Function<Product, String> PRODUCT_TO_HOST_TYPE = new Function<Product, String>(){

        public String apply(@Nullable Product input) {
            return input.getHostType();
        }
    };

    private ProductUtils() {
        throw new UnsupportedOperationException();
    }

    public static Predicate<HostProductEntity> getLicenseFilter(final HostEntity host, final LicensedApplicationSource licenseSource) {
        return new Predicate<HostProductEntity>(){

            public boolean apply(HostProductEntity product) {
                return licenseSource.isProductLicensed(ProductUtils.getProductLicenseNamespace(host, product));
            }
        };
    }

    public static String getProductLicenseNamespace(HostEntity host, HostProductEntity product) {
        return host.getLicensing().getLicensePrefix() + product.getProductKey();
    }
}

