/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service.products;

import com.atlassian.crowd.plugin.usermanagement.service.products.HostDataStorage;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.host.HostEntity;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostDataStorePluginSettings
implements HostDataStorage {
    private static final Logger log = LoggerFactory.getLogger(HostDataStorePluginSettings.class);
    private static final String APPLICATION_STORAGE_KEY = "application.access.data";
    private static final String APPLICATION_LIST = "application.config.list";
    private final PluginSettings pluginSettings;
    private final ObjectMapper mapper = new ObjectMapper();
    private final ObjectReader productReader = this.mapper.reader(HostEntity.class);
    private final ObjectReader listReader = this.mapper.reader(HostApplicationData.class);

    public HostDataStorePluginSettings(PluginSettingsFactory pluginSettingsFactory) throws IOException {
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey(APPLICATION_STORAGE_KEY);
    }

    @Override
    public boolean store(HostEntity entity) {
        try {
            if (entity != null) {
                String hostId = entity.getDescription().getHostId();
                String jsonEntity = this.mapper.writeValueAsString((Object)entity);
                if (jsonEntity != null) {
                    this.pluginSettings.put(hostId, (Object)jsonEntity);
                    HostApplicationData hostApplicationData = this.getHostListEntity();
                    if (!hostApplicationData.getApplications().contains(hostId)) {
                        hostApplicationData.getApplications().add(hostId);
                        this.pluginSettings.put(APPLICATION_LIST, (Object)this.mapper.writeValueAsString((Object)hostApplicationData));
                    }
                }
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to store config: " + entity, e);
        }
        return false;
    }

    @Override
    public Set<HostEntity> retrieveAll() {
        Set<String> storedHosts = this.getHostList();
        HashSet<HostEntity> hosts = new HashSet<HostEntity>();
        for (String hostId : storedHosts) {
            HostEntity entity = this.retrieve(hostId);
            if (entity == null) continue;
            hosts.add(entity);
        }
        return hosts;
    }

    @Override
    @Nullable
    public HostEntity retrieve(String hostId) {
        String productJson;
        Set<String> storedHosts = this.getHostList();
        if (storedHosts.contains(hostId) && (productJson = (String)this.pluginSettings.get(hostId)) != null) {
            try {
                HostEntity pluginSettingsEntity = (HostEntity)this.productReader.readValue((String)this.pluginSettings.get(hostId));
                return pluginSettingsEntity;
            }
            catch (JsonMappingException upe) {
                this.delete(hostId);
                log.warn("Removed invalid product configuration for host: " + hostId, (Throwable)upe);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to read stored config", e);
            }
        }
        return null;
    }

    @Override
    public void delete(String hostId) {
        try {
            HostApplicationData hostApplicationData = this.getHostListEntity();
            hostApplicationData.getApplications().remove(hostId);
            this.pluginSettings.remove(hostId);
            this.pluginSettings.put(APPLICATION_LIST, (Object)this.mapper.writeValueAsString((Object)hostApplicationData));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to remove config for host: " + hostId, e);
        }
    }

    private Set<String> getHostList() {
        return ImmutableSet.copyOf(this.getHostListEntity().getApplications());
    }

    private HostApplicationData getHostListEntity() {
        String productListJson = (String)this.pluginSettings.get(APPLICATION_LIST);
        if (productListJson != null) {
            try {
                return (HostApplicationData)this.listReader.readValue(productListJson);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read list of host applications from plugin settings: application.access.data - application.config.list", e);
            }
        }
        return new HostApplicationData();
    }

    @JsonAutoDetect
    public static class HostApplicationData {
        private List<String> applications;

        private HostApplicationData(@JsonProperty(value="applications") List<String> applications) {
            this.applications = applications;
        }

        @JsonIgnore
        private HostApplicationData() {
            this.applications = new ArrayList<String>();
        }

        public List<String> getApplications() {
            return this.applications;
        }
    }
}

