/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service.products;

import com.atlassian.applinks.api.ReadOnlyApplicationLink;

public enum ApplinkProductType {
    BAMBOO("applinks.bamboo", "bamboo", "com.atlassian.bamboo", "/admin/viewGlobalPermissions.action"),
    CONFLUENCE("applinks.confluence", "confluence", "com.atlassian.confluence", "/admin/permissions/globalpermissions.action"),
    JIRA("applinks.jira", "jira", "com.atlassian.jira", "/secure/admin/GlobalPermissions!default.jspa");

    private final String i18nKey;
    private final String productName;
    private final String productKey;
    private final String productPermissionsPath;

    private ApplinkProductType(String applinksI18NKey, String productName, String productKey, String productPermissionsPath) {
        this.i18nKey = applinksI18NKey;
        this.productName = productName;
        this.productKey = productKey;
        this.productPermissionsPath = productPermissionsPath;
    }

    public String getHostType() {
        return this.productName;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public String getPermissionsPath() {
        return this.productPermissionsPath;
    }

    public static ApplinkProductType getProductType(ReadOnlyApplicationLink link) {
        for (ApplinkProductType productType : ApplinkProductType.values()) {
            if (!productType.i18nKey.equals(link.getType().getI18nKey())) continue;
            return productType;
        }
        throw new IllegalArgumentException("Unknown applinks product, with key: " + link.getType().getI18nKey());
    }

    public static String getHostType(ReadOnlyApplicationLink link) throws IllegalArgumentException {
        return ApplinkProductType.getProductType(link).getHostType();
    }

    public static String getProductKey(ReadOnlyApplicationLink link) throws IllegalArgumentException {
        return ApplinkProductType.getProductType(link).getProductKey();
    }

    public static String getPermissionsPath(ReadOnlyApplicationLink link) throws IllegalArgumentException {
        return ApplinkProductType.getProductType(link).getPermissionsPath();
    }
}

