/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service.passwordscore;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.PasswordScore;
import com.atlassian.crowd.embedded.api.PasswordScoreService;
import com.atlassian.crowd.plugin.usermanagement.service.passwordscore.PasswordPolicyWebResource;
import com.atlassian.crowd.plugin.usermanagement.service.passwordscore.PasswordScoreResult;
import com.atlassian.crowd.plugin.usermanagement.service.passwordscore.ServiceUnavailableException;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

class PasswordScoreServiceImpl
implements PasswordScoreService {
    private final PasswordPolicyWebResource passwordPolicyWebResource;

    public PasswordScoreServiceImpl(PasswordPolicyWebResource passwordPolicyWebResource) {
        this.passwordPolicyWebResource = passwordPolicyWebResource;
    }

    public PasswordScore getPasswordScore(PasswordCredential passwordCredential, Collection<String> userInfo) {
        try {
            String password = passwordCredential.getCredential();
            PasswordScoreResult passwordScoreResult = this.passwordPolicyWebResource.getPasswordScore(password, (List<String>)ImmutableList.copyOf(userInfo));
            return PasswordScore.fromRanking((long)passwordScoreResult.getScore());
        }
        catch (ServiceUnavailableException serviceUnavailableException) {
            return PasswordScore.WEAK;
        }
    }
}

