/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.SeatsEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.NoDefaultGroupException;
import com.atlassian.crowd.plugin.usermanagement.service.ConflictingConfiguration;
import com.atlassian.crowd.plugin.usermanagement.service.GrantProductAccessResult;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.service.validation.Failure;
import com.atlassian.crowd.plugin.usermanagement.service.validation.IntertwinedConfiguration;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.AccessLevel;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.base.Function;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface UserProvisioningService {
    public Option<Integer> getAvailableSeatsForProduct(Product var1) throws DirectoryNotFoundException, OperationFailedException;

    public Integer getUserCountForProduct(Product var1) throws DirectoryNotFoundException, OperationFailedException;

    public SeatsEntity getSeatsEntityForProduct(Product var1) throws DirectoryNotFoundException, OperationFailedException;

    public Collection<IntertwinedConfiguration> detectIntertwinedConfigurations(List<Product> var1);

    public Map<Product, AccessLevel> getAccessLevel(String var1, List<Product> var2) throws DirectoryNotFoundException, OperationFailedException;

    public Set<String> findUsernamesGrantedAccessToProduct(Product var1) throws DirectoryNotFoundException, OperationFailedException;

    public Set<String> findUsernamesTakingLicenseSeatsToProduct(Product var1) throws DirectoryNotFoundException, OperationFailedException;

    public Set<User> findUsersGrantedAccessToProduct(Product var1) throws DirectoryNotFoundException, OperationFailedException;

    public Either<ConflictingConfiguration, Set<String>> updateAccessLevel(String var1, Map<Product, AccessLevel> var2, boolean var3, List<Product> var4) throws DirectoryNotFoundException, OperationFailedException, UserNotFoundException, GroupNotFoundException, ReadOnlyGroupException, DirectoryPermissionException, CredentialsRequiredException, ResponseException;

    public Either<ConflictingConfiguration, Set<String>> updateUseAccessLevel(String var1, Map<Product, Boolean> var2, boolean var3, List<Product> var4) throws DirectoryNotFoundException, OperationFailedException, UserNotFoundException, GroupNotFoundException, ReadOnlyGroupException, DirectoryPermissionException, CredentialsRequiredException, ResponseException;

    public Map<Product, Either<Failure, GrantProductAccessResult>> grantProductAccess(Set<String> var1, Iterable<Product> var2, boolean var3) throws DirectoryNotFoundException, OperationFailedException, NoDefaultGroupException;

    public Map<Product, Either<Failure, GrantProductAccessResult>> grantProductAccessAnonymously(Set<String> var1, Iterable<Product> var2) throws DirectoryNotFoundException, OperationFailedException, NoDefaultGroupException;

    public Set<String> findUsernamesExcludedFromLicenseCount(Product var1) throws DirectoryNotFoundException, OperationFailedException;

    public Either<Map<Product, Failure>, ReservedProductAccess> reserveProductAccess(int var1, Iterable<Product> var2);

    public Either<Map<Product, Failure>, ReservedProductAccess> reserveProductAccessAnonymously(int var1, Iterable<Product> var2);

    public Set<String> filterOutInactiveUsers(Set<String> var1);

    public Set<String> getAllLoginGroups(Product var1);

    public Set<String> getAllLoginUsers(Product var1);

    public Map<Product, Boolean> getProductDefaults(List<Product> var1);

    public void updateProductDefaults(Map<Product, Boolean> var1);

    public Iterable<Product> getDefaultProducts(List<Product> var1);

    public static interface ReservedProductAccess
    extends Function<Set<String>, Map<Product, GrantProductAccessResult>> {
    }
}

