/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service;

import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ProductDescriptionEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.LicenseExceededException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ProductAppAccessUpdateException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ProductNotConfigurableException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ProductNotFoundException;
import com.atlassian.crowd.plugin.usermanagement.service.ApplicationLinkConfigService;
import com.atlassian.crowd.plugin.usermanagement.service.DirectoryLocator;
import com.atlassian.crowd.plugin.usermanagement.service.ProductId;
import com.atlassian.crowd.plugin.usermanagement.service.ProductService;
import com.atlassian.crowd.plugin.usermanagement.service.ReadOnlyApplicationLinkWithConfig;
import com.atlassian.crowd.plugin.usermanagement.service.UserProvisioningService;
import com.atlassian.crowd.plugin.usermanagement.service.products.ApplinkProduct;
import com.atlassian.crowd.plugin.usermanagement.service.products.HostDataStorage;
import com.atlassian.crowd.plugin.usermanagement.service.products.HostDataStorePluginSettings;
import com.atlassian.crowd.plugin.usermanagement.service.products.HostedProduct;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.service.products.ProductConfig;
import com.atlassian.crowd.plugin.usermanagement.service.products.ProductUtils;
import com.atlassian.crowd.plugin.usermanagement.service.validation.LicenseCheckFunctionGrantAccessToGroups;
import com.atlassian.crowd.plugin.usermanagement.service.validation.LicenseExceeded;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ProductAccessError;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.AccessLevel;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.config.CrowdAttributeFormat;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.config.CrowdAttributesService;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.config.CrowdPermissionAdapter;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.GroupAttributesEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.PermissionEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.host.HostEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.host.HostProductEntity;
import com.atlassian.crowd.plugin.usermanagement.util.ExplicitOrdering;
import com.atlassian.crowd.plugin.usermanagement.util.SystemPropertyUtil;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.util.license.LicensedApplicationSource;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductServiceImpl
implements ProductService {
    private static final Logger log = LoggerFactory.getLogger(ProductServiceImpl.class);
    private final CrowdAttributesService crowdAttributesService;
    private final HostDataStorage hostDataStore;
    private final ApplicationLinkConfigService configService;
    private final DirectoryManager directoryManager;
    private final DirectoryLocator directoryLocator;
    private final CrowdPermissionAdapter permissionsAdapter;
    private final LicensedApplicationSource licensedApplicationSource;

    public ProductServiceImpl(PluginSettingsFactory pluginSettingsFactory, CrowdAttributesService crowdAttributesService, ApplicationLinkConfigService configService, LicensedApplicationSource licensedApplicationSource, DirectoryManager directoryManager, DirectoryLocator directoryLocator) throws IOException {
        this(crowdAttributesService, new HostDataStorePluginSettings(pluginSettingsFactory), configService, licensedApplicationSource, directoryManager, directoryLocator);
    }

    @VisibleForTesting
    public ProductServiceImpl(CrowdAttributesService crowdAttributesService, HostDataStorage hostDataStore, ApplicationLinkConfigService configService, LicensedApplicationSource licensedApplicationSource, DirectoryManager directoryManager, DirectoryLocator directoryLocator) {
        this.crowdAttributesService = crowdAttributesService;
        this.hostDataStore = hostDataStore;
        this.configService = configService;
        this.directoryManager = directoryManager;
        this.directoryLocator = directoryLocator;
        this.permissionsAdapter = new CrowdPermissionAdapter(crowdAttributesService);
        this.licensedApplicationSource = licensedApplicationSource;
    }

    @Override
    public void updateHostConfig(HostEntity serverConfig) {
        if (serverConfig != null) {
            this.createAllGroupsMentioned(serverConfig);
            String hostId = serverConfig.getDescription().getHostId();
            HostEntity oldConfig = this.hostDataStore.retrieve(hostId);
            PermissionEntity previousAdmin = this.permissionsAdapter.fetchAdminPermissions(hostId);
            PermissionEntity previousSysadmin = this.permissionsAdapter.fetchSysAdminPermissions(hostId);
            PermissionEntity newAdmin = serverConfig.getAdministration().getPermissions().get((Object)AccessLevel.ADMIN);
            PermissionEntity newSysadmin = serverConfig.getAdministration().getPermissions().get((Object)AccessLevel.SYSADMIN);
            if (oldConfig == null && previousAdmin.getGroups().isEmpty() && previousSysadmin.getGroups().isEmpty()) {
                this.permissionsAdapter.writeAdminPermissions(hostId, newAdmin);
                this.permissionsAdapter.writeSysAdminPermissions(hostId, newSysadmin);
            } else {
                this.permissionsAdapter.writeUnapprovedAdminPermissions(hostId, newAdmin);
            }
            for (String productKey : serverConfig.getProductKeys()) {
                PermissionEntity previousUse = this.permissionsAdapter.fetchUsePermissions(hostId, productKey);
                PermissionEntity newUse = serverConfig.getProduct(productKey).getPermissions();
                if ((oldConfig == null || !oldConfig.getProductKeys().contains(productKey)) && previousUse.getGroups().isEmpty()) {
                    this.permissionsAdapter.writeUsePermissions(hostId, productKey, newUse);
                    log.info("Initialising permission attributes for product: " + productKey);
                    continue;
                }
                if (!this.permissionsAdapter.writeUnapprovedUsePermissions(hostId, productKey, newUse)) continue;
                log.info("Re-initialising unapproved permission attributes for product: " + productKey);
            }
            this.hostDataStore.store(serverConfig);
        }
    }

    private void createAllGroupsMentioned(HostEntity hostEntity) {
        for (String group : this.getAllGroupsMentioned(hostEntity)) {
            try {
                this.directoryManager.findGroupByName(this.directoryLocator.getDirectoryId(), group);
            }
            catch (GroupNotFoundException groupNotFoundException) {
                try {
                    this.directoryManager.addGroup(this.directoryLocator.getDirectoryId(), new GroupTemplate(group, this.directoryLocator.getDirectoryId()));
                }
                catch (DirectoryNotFoundException | InvalidGroupException | OperationFailedException | DirectoryPermissionException ignoredException) {
                    log.error("Failed to add missing group while initialising product: " + hostEntity.getDescription().getHostId(), ignoredException);
                }
            }
            catch (DirectoryNotFoundException | OperationFailedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Set<String> getAllGroupsMentioned(HostEntity hostEntity) {
        HashSet groups = Sets.newHashSet();
        groups.addAll(this.getAllGroupsMentioned(hostEntity.getAdministration().getPermissions().values()));
        for (HostProductEntity hostProductEntity : hostEntity.getProducts()) {
            groups.addAll(this.getAllGroupsMentioned((Collection<PermissionEntity>)ImmutableSet.of((Object)hostProductEntity.getPermissions())));
        }
        return groups;
    }

    private Set<String> getAllGroupsMentioned(Collection<PermissionEntity> permissionEntities) {
        HashSet groups = Sets.newHashSet();
        for (PermissionEntity permissionEntity : permissionEntities) {
            groups.addAll(permissionEntity.getGroups().keySet());
        }
        return groups;
    }

    @Override
    public Option<HostEntity> retrieve(String hostId) {
        HostEntity entity = this.hostDataStore.retrieve(hostId);
        return entity != null ? Option.some(entity) : Option.none();
    }

    @Override
    public void deleteHostConfig(String hostId) throws IOException {
        Option<HostEntity> maybeHostConfig = this.retrieve(hostId);
        if (maybeHostConfig.isDefined()) {
            HostEntity hostEntity = (HostEntity)maybeHostConfig.get();
            this.permissionsAdapter.clearAllPermissions(hostId, hostEntity.getProductKeys());
        }
        this.hostDataStore.delete(hostId);
    }

    @Override
    public List<Product> fetchProducts() {
        HashSet<URI> configuredHosts = new HashSet<URI>();
        ImmutableList.Builder products = ImmutableList.builder();
        for (HostEntity hostEntity : this.hostDataStore.retrieveAll()) {
            configuredHosts.add(hostEntity.getDescription().getRpcURI());
            products.addAll(this.getLicensedHostedProducts(hostEntity, (Predicate<HostProductEntity>)Predicates.alwaysTrue()));
        }
        Iterable<ReadOnlyApplicationLink> links = this.configService.getAllLinksForAllApplications();
        for (ReadOnlyApplicationLink link : links) {
            if (configuredHosts.contains(link.getRpcUrl())) continue;
            ReadOnlyApplicationLinkWithConfig linkWithConfig = this.configService.fetchConfigForApplication(link);
            products.add((Object)new ApplinkProduct(linkWithConfig));
        }
        return ProductServiceImpl.reorderProducts((List<Product>)products.build(), SystemPropertyUtil.parseProductOrderSystemProperty());
    }

    @Override
    public List<ProductDescriptionEntity> fetchProductDescription() {
        HashSet<URI> configuredHosts = new HashSet<URI>();
        ImmutableList.Builder products = ImmutableList.builder();
        for (HostEntity hostEntity : this.hostDataStore.retrieveAll()) {
            configuredHosts.add(hostEntity.getDescription().getRpcURI());
            for (HostProductEntity product : hostEntity.getProducts()) {
                products.add((Object)new ProductDescriptionEntity(product.getName(), ProductId.fromHostIdAndProductKey(hostEntity.getDescription().getHostId(), product.getProductKey()).getId()));
            }
        }
        Iterable<ReadOnlyApplicationLink> links = this.configService.getAllLinksForAllApplications();
        for (ReadOnlyApplicationLink link : links) {
            if (configuredHosts.contains(link.getRpcUrl())) continue;
            products.add((Object)new ProductDescriptionEntity(link.getName(), link.getId().get()));
        }
        return ProductServiceImpl.reorderProductDescriptions((List<ProductDescriptionEntity>)products.build(), SystemPropertyUtil.parseProductOrderSystemProperty());
    }

    protected List<Product> getLicensedHostedProducts(HostEntity hostEntity, Predicate<HostProductEntity> productFilter) {
        return this.getHostedProducts(hostEntity, (Predicate<HostProductEntity>)Predicates.and(productFilter, ProductUtils.getLicenseFilter(hostEntity, this.licensedApplicationSource)));
    }

    private List<Product> getHostedProducts(final HostEntity hostEntity, Predicate<HostProductEntity> productFilter) {
        final String hostId = hostEntity.getDescription().getHostId();
        Iterable filteredProducts = com.google.common.collect.Iterables.filter(hostEntity.getProducts(), productFilter);
        return ImmutableList.copyOf((Iterable)com.google.common.collect.Iterables.transform((Iterable)filteredProducts, (Function)new Function<HostProductEntity, Product>(){

            public Product apply(@Nullable HostProductEntity productEntity) {
                String productKey = productEntity.getProductKey();
                Map<AccessLevel, PermissionEntity> permissions = ProductServiceImpl.this.permissionsAdapter.fetchPermissions(hostId, productEntity.getProductKey(), productEntity.isPlatform());
                return new HostedProduct(ProductId.fromHostIdAndProductKey(hostId, productKey), hostEntity, productKey, permissions);
            }
        }));
    }

    @Override
    public List<Product> fetchProducts(Iterable<ProductId> productIds) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ProductId productId : productIds) {
            Option<Product> maybeProduct = this.getProduct(productId);
            for (Product product : maybeProduct) {
                builder.add((Object)product);
            }
        }
        return ProductServiceImpl.reorderProducts((List<Product>)builder.build(), SystemPropertyUtil.parseProductOrderSystemProperty());
    }

    public static List<Product> reorderProducts(@Nonnull List<Product> products, @Nonnull List<String> order) {
        return new ExplicitOrdering<String>(order).onResultOf((Function)new Function<Product, String>(){

            public String apply(Product o) {
                return o.getProductKey();
            }
        }).immutableSortedCopy(products);
    }

    public static List<ProductDescriptionEntity> reorderProductDescriptions(@Nonnull List<ProductDescriptionEntity> products, @Nonnull List<String> order) {
        return new ExplicitOrdering<String>(order).onResultOf((Function)new Function<ProductDescriptionEntity, String>(){

            public String apply(ProductDescriptionEntity o) {
                return o.getId();
            }
        }).immutableSortedCopy(products);
    }

    @Override
    public Option<Product> getProduct(ProductId productId) {
        for (HostEntity entity : this.hostDataStore.retrieveAll()) {
            String hostId;
            List<Product> products = this.getLicensedHostedProducts(entity, new Predicate<HostProductEntity>(hostId = entity.getDescription().getHostId(), productId){
                final /* synthetic */ String val$hostId;
                final /* synthetic */ ProductId val$productId;
                {
                    this.val$hostId = string;
                    this.val$productId = productId;
                }

                public boolean apply(@Nullable HostProductEntity product) {
                    ProductId renaissanceId = ProductId.fromHostIdAndProductKey(this.val$hostId, product.getProductKey());
                    return this.val$productId.equals(renaissanceId);
                }
            });
            if (products.isEmpty()) continue;
            return Iterables.first(products);
        }
        Option<ReadOnlyApplicationLink> link = this.configService.getApplicationLink(productId.toString());
        if (link.isDefined()) {
            ReadOnlyApplicationLinkWithConfig linkWithConfig = this.configService.fetchConfigForApplication((ReadOnlyApplicationLink)link.get());
            ApplinkProduct product = new ApplinkProduct(linkWithConfig);
            return Option.some(product);
        }
        return Option.none();
    }

    private ProductConfig fetchRequiredProductConfig(Product product) throws ProductNotConfigurableException {
        Either<ProductAccessError, ProductConfig> maybeConfig = product.fetchProductConfig();
        if (maybeConfig.isLeft() || !((ProductConfig)maybeConfig.right().get()).isConfigurable().booleanValue()) {
            throw new ProductNotConfigurableException(product);
        }
        return (ProductConfig)maybeConfig.right().get();
    }

    private void checkLicenseNotExceeded(Product product, String group, UserProvisioningService userProvisioningService, AccessLevel accessLevel) throws LicenseExceededException {
        LicenseCheckFunctionGrantAccessToGroups licenseCheck = new LicenseCheckFunctionGrantAccessToGroups(this.directoryLocator, this.directoryManager, Sets.newHashSet((Object[])new String[]{group}), userProvisioningService, accessLevel);
        Option possibleLicenseExceeded = licenseCheck.apply(product);
        if (possibleLicenseExceeded.isDefined()) {
            throw new LicenseExceededException((Map<Product, LicenseExceeded>)ImmutableMap.of((Object)product, possibleLicenseExceeded.get()));
        }
    }

    @Override
    public void grantAccess(ProductId productId, String group, AccessLevel level, UserProvisioningService userProvisioningService) throws ProductNotFoundException, ProductNotConfigurableException, ProductAppAccessUpdateException, LicenseExceededException {
        Product product = (Product)this.getProduct(productId).getOrThrow(new ProductNotFoundSupplier(productId));
        ProductConfig config = this.fetchRequiredProductConfig(product);
        this.checkLicenseNotExceeded(product, group, userProvisioningService, level);
        switch (level) {
            case SYSADMIN: {
                throw new ProductAppAccessUpdateException(product, "usermanagement.accessconfig.invalid.sysadmin");
            }
            case ADMIN: {
                if (!config.isPlatformProduct().booleanValue()) {
                    throw new ProductAppAccessUpdateException(product, "usermanagement.accessconfig.invalid.admin.non.platform");
                }
                List<Product> allProducts = this.fetchProducts();
                if (this.hasDefaultUseAccess(allProducts, group)) {
                    throw new ProductAppAccessUpdateException(product, "usermanagement.accessconfig.invalid.has.default.use");
                }
                this.crowdAttributesService.addAttribute(group, CrowdAttributeFormat.generateAdmin(product.getHostId()));
                break;
            }
            case USE: {
                this.crowdAttributesService.addAttribute(group, CrowdAttributeFormat.generateUse(product.getHostId(), product.getProductKey()));
                break;
            }
            default: {
                throw new RuntimeException("Invalid access level specified in application access request: " + (Object)((Object)level));
            }
        }
    }

    @Override
    public void grantDefaultAccess(ProductId productId, String group, UserProvisioningService userProvisioningService) throws ProductNotFoundException, ProductNotConfigurableException, ProductAppAccessUpdateException, LicenseExceededException {
        Product product = (Product)this.getProduct(productId).getOrThrow(new ProductNotFoundSupplier(productId));
        this.checkLicenseNotExceeded(product, group, userProvisioningService, AccessLevel.USE);
        List<Product> allProducts = this.fetchProducts();
        if (this.hasAdminAccess(allProducts, group)) {
            throw new ProductAppAccessUpdateException(product, "usermanagement.accessconfig.invalid.has.admin");
        }
        this.crowdAttributesService.addAttribute(group, CrowdAttributeFormat.generateUse(product.getHostId(), product.getProductKey()));
        this.crowdAttributesService.addAttribute(group, CrowdAttributeFormat.generateDefaultUse(product.getHostId(), product.getProductKey()));
    }

    @Override
    public void removeDefaultAccess(ProductId productId, String group) throws ProductNotFoundException, ProductNotConfigurableException, ProductAppAccessUpdateException {
        Product product = (Product)this.getProduct(productId).getOrThrow(new ProductNotFoundSupplier(productId));
        Set<String> defaultGroups = this.fetchRequiredProductConfig(product).getDefaultGroups(AccessLevel.USE);
        if (defaultGroups.contains(group) && defaultGroups.size() == 1) {
            throw new ProductAppAccessUpdateException(product, "usermanagement.accessconfig.invalid.last.default");
        }
        this.crowdAttributesService.removeAttribute(group, CrowdAttributeFormat.generateDefaultUse(product.getHostId(), product.getProductKey()));
    }

    @Override
    public void approveAccess(ProductId productId, String groupName, UserProvisioningService userProvisioningService) throws ProductNotFoundException, ProductNotConfigurableException, ProductAppAccessUpdateException, LicenseExceededException, GroupNotFoundException, DirectoryNotFoundException, OperationFailedException {
        boolean needsAdmin;
        Product product = (Product)this.getProduct(productId).getOrThrow(new ProductNotFoundSupplier(productId));
        ProductConfig config = this.fetchRequiredProductConfig(product);
        GroupWithAttributes group = this.directoryManager.findGroupWithAttributesByName(this.directoryLocator.getDirectoryId(), groupName);
        Set attributes = group.getKeys();
        String unapprovedUseAttribute = CrowdAttributeFormat.generateUnapprovedUse(product.getHostId(), product.getProductKey(), false);
        String unapprovedDefaultAttribute = CrowdAttributeFormat.generateUnapprovedUse(product.getHostId(), product.getProductKey(), true);
        String unapprovedAdminAttribute = CrowdAttributeFormat.generateUnapprovedAdmin(product.getHostId());
        boolean needsUse = attributes.contains(unapprovedUseAttribute);
        boolean needsDefault = attributes.contains(unapprovedDefaultAttribute);
        boolean bl = needsAdmin = product.isPlatform() && attributes.contains(unapprovedAdminAttribute);
        if (needsUse) {
            this.checkLicenseNotExceeded(product, groupName, userProvisioningService, AccessLevel.USE);
        }
        if (needsAdmin && config.getCanLoginLevels().contains((Object)AccessLevel.ADMIN)) {
            this.checkLicenseNotExceeded(product, groupName, userProvisioningService, AccessLevel.ADMIN);
        }
        if (needsUse) {
            this.crowdAttributesService.removeAttribute(groupName, unapprovedUseAttribute);
            this.crowdAttributesService.addAttribute(groupName, CrowdAttributeFormat.generateUse(product.getHostId(), product.getProductKey()));
        }
        if (needsDefault) {
            this.crowdAttributesService.removeAttribute(groupName, unapprovedDefaultAttribute);
            this.crowdAttributesService.addAttribute(groupName, CrowdAttributeFormat.generateDefaultUse(product.getHostId(), product.getProductKey()));
        }
        if (needsAdmin) {
            this.crowdAttributesService.removeAttribute(groupName, unapprovedAdminAttribute);
            this.crowdAttributesService.addAttribute(groupName, CrowdAttributeFormat.generateAdmin(product.getHostId()));
        }
    }

    @Override
    public void rejectAccess(ProductId productId, String groupName, UserProvisioningService userProvisioningService) throws ProductNotFoundException, ProductNotConfigurableException, ProductAppAccessUpdateException, LicenseExceededException, GroupNotFoundException, DirectoryNotFoundException, OperationFailedException {
        Product product = (Product)this.getProduct(productId).getOrThrow(new ProductNotFoundSupplier(productId));
        String unapprovedUseAttribute = CrowdAttributeFormat.generateUnapprovedUse(product.getHostId(), product.getProductKey(), false);
        String unapprovedDefaultAttribute = CrowdAttributeFormat.generateUnapprovedUse(product.getHostId(), product.getProductKey(), true);
        String unapprovedAdminAttribute = CrowdAttributeFormat.generateUnapprovedAdmin(product.getHostId());
        this.crowdAttributesService.removeAttribute(groupName, unapprovedUseAttribute);
        this.crowdAttributesService.removeAttribute(groupName, unapprovedDefaultAttribute);
        this.crowdAttributesService.removeAttribute(groupName, unapprovedAdminAttribute);
    }

    @Override
    public void revokeAccess(ProductId productId, String group, AccessLevel level) throws ProductNotFoundException, ProductNotConfigurableException, ProductAppAccessUpdateException {
        Product product = (Product)this.getProduct(productId).getOrThrow(new ProductNotFoundSupplier(productId));
        ProductConfig config = this.fetchRequiredProductConfig(product);
        switch (level) {
            case SYSADMIN: {
                throw new ProductAppAccessUpdateException(product, "usermanagement.accessconfig.invalid.sysadmin");
            }
            case ADMIN: {
                Set<String> existingAdminGroups = config.getGroups(AccessLevel.ADMIN);
                if (existingAdminGroups.size() == 1 && existingAdminGroups.contains(group)) {
                    throw new ProductAppAccessUpdateException(product, "usermanagement.accessconfig.invalid.cant.remove.last.admin");
                }
                if (config.getDefaultGroups(AccessLevel.ADMIN).contains(group)) {
                    throw new ProductAppAccessUpdateException(product, "usermanagement.accessconfig.invalid.cant.revoke.default.admin");
                }
                this.crowdAttributesService.removeAttribute(group, CrowdAttributeFormat.generateAdmin(product.getHostId()));
                break;
            }
            case USE: {
                if (config.getDefaultGroups(AccessLevel.USE).contains(group)) {
                    throw new ProductAppAccessUpdateException(product, "usermanagement.accessconfig.invalid.cant.revoke.default.use");
                }
                this.crowdAttributesService.removeAttribute(group, CrowdAttributeFormat.generateUse(product.getHostId(), product.getProductKey()));
                break;
            }
            default: {
                throw new RuntimeException("Invalid access level specified in application access request");
            }
        }
    }

    @Override
    public boolean hasDefaultUseAccess(List<Product> allProducts, String group) {
        for (Product product : allProducts) {
            Either<ProductAccessError, ProductConfig> maybeConfig = product.fetchProductConfig();
            for (ProductConfig config : maybeConfig.right()) {
                if (!config.getDefaultGroups(AccessLevel.USE).contains(group)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasAdminAccess(List<Product> allProducts, String group) {
        for (Product product : allProducts) {
            Either<ProductAccessError, ProductConfig> maybeConfig = product.fetchProductConfig();
            for (ProductConfig config : maybeConfig.right()) {
                if (!config.getGroups(AccessLevel.ADMIN).contains(group)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasDefaultAccess(List<Product> allProducts, String group) {
        for (Product product : allProducts) {
            Either<ProductAccessError, ProductConfig> maybeConfig = product.fetchProductConfig();
            for (ProductConfig config : maybeConfig.right()) {
                if (config.getDefaultGroups(AccessLevel.USE).contains(group)) {
                    return true;
                }
                if (!config.getDefaultGroups(AccessLevel.ADMIN).contains(group)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Product> getNonPlatformProducts(Product product) {
        ArrayList products = Lists.newArrayList();
        Option<HostEntity> hostEntityOption = this.retrieve(product.getHostId());
        if (hostEntityOption.isDefined() && product.isPlatform()) {
            HostEntity hostEntity = (HostEntity)hostEntityOption.get();
            for (HostProductEntity hostProductEntity : hostEntity.getProducts()) {
                Option<Product> possibleNonPlatformProduct = this.getProduct(ProductId.fromHostIdAndProductKey(hostEntity.getDescription().getHostId(), hostProductEntity.getProductKey()));
                if (!possibleNonPlatformProduct.isDefined() || ((Product)possibleNonPlatformProduct.get()).getProductId().equals(product.getProductId())) continue;
                products.add(possibleNonPlatformProduct.get());
            }
        }
        return products;
    }

    @Override
    public void revokeAllAccess(List<String> exceptGroups) {
        for (HostEntity hostEntity : this.hostDataStore.retrieveAll()) {
            for (Product product : this.getHostedProducts(hostEntity, (Predicate<HostProductEntity>)Predicates.alwaysTrue())) {
                try {
                    ProductConfig config = this.fetchRequiredProductConfig(product);
                    for (Map.Entry<String, GroupAttributesEntity> entry : config.getGroupPermissions(AccessLevel.USE).entrySet()) {
                        if (exceptGroups.contains(entry.getKey())) continue;
                        this.requireApproval(product, entry.getKey(), entry.getValue().isDefault(), AccessLevel.USE);
                    }
                    for (Map.Entry<String, GroupAttributesEntity> entry : config.getGroupPermissions(AccessLevel.ADMIN).entrySet()) {
                        if (exceptGroups.contains(entry.getKey())) continue;
                        this.requireApproval(product, entry.getKey(), entry.getValue().isDefault(), AccessLevel.ADMIN);
                    }
                }
                catch (ProductNotConfigurableException e) {
                }
            }
        }
    }

    private void requireApproval(Product product, String groupName, boolean isDefault, AccessLevel accessLevel) {
        switch (accessLevel) {
            case ADMIN: {
                if (!product.isPlatform()) break;
                this.crowdAttributesService.removeAttribute(groupName, CrowdAttributeFormat.generateAdmin(product.getHostId()));
                this.crowdAttributesService.addAttribute(groupName, CrowdAttributeFormat.generateUnapprovedAdmin(product.getHostId()));
                break;
            }
            case USE: {
                this.crowdAttributesService.removeAttribute(groupName, CrowdAttributeFormat.generateUse(product.getHostId(), product.getProductKey()));
                this.crowdAttributesService.addAttribute(groupName, CrowdAttributeFormat.generateUnapprovedUse(product.getHostId(), product.getProductKey(), false));
                if (!isDefault) break;
                this.crowdAttributesService.removeAttribute(groupName, CrowdAttributeFormat.generateDefaultUse(product.getHostId(), product.getProductKey()));
                this.crowdAttributesService.addAttribute(groupName, CrowdAttributeFormat.generateUnapprovedUse(product.getHostId(), product.getProductKey(), true));
                break;
            }
            default: {
                throw new RuntimeException("Invalid access level specified in require approval request");
            }
        }
    }

    @Override
    public Set<String> getGroupsRequiringApproval(Product product, AccessLevel accessLevel, boolean isDefault) {
        String attribute;
        if (!product.isPlatform() && accessLevel != AccessLevel.USE) {
            return new HashSet<String>();
        }
        switch (accessLevel) {
            case USE: {
                attribute = CrowdAttributeFormat.generateUnapprovedUse(product.getHostId(), product.getProductKey(), isDefault);
                break;
            }
            case ADMIN: {
                attribute = CrowdAttributeFormat.generateUnapprovedAdmin(product.getHostId());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid access level specified in require approval request");
            }
        }
        return this.crowdAttributesService.getGroupsWithAttribute(attribute);
    }

    @Override
    public Option<Product> getProduct(List<Product> products, ProductId productId) {
        return Iterables.findFirst(products, new MatchProductId(productId));
    }

    public static class ProductNotFoundSupplier
    implements Supplier<ProductNotFoundException> {
        private ProductId productId;

        public ProductNotFoundSupplier(ProductId productId) {
            this.productId = productId;
        }

        public ProductNotFoundException get() {
            return new ProductNotFoundException(this.productId);
        }
    }

    private class MatchProductId
    implements Predicate<Product> {
        private final ProductId productId;

        public MatchProductId(ProductId productId) {
            this.productId = productId;
        }

        public boolean apply(@Nullable Product input) {
            return input != null && this.productId != null && this.productId.equals(input.getProductId());
        }
    }
}

