/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service;

import com.atlassian.crowd.exception.ObjectAlreadyExistsException;
import com.atlassian.crowd.model.token.ExpirableUserToken;
import com.atlassian.crowd.plugin.usermanagement.service.DirectoryLocator;
import com.atlassian.crowd.plugin.usermanagement.service.InvitationService;
import com.atlassian.crowd.service.token.InviteUserTokenService;
import com.atlassian.fugue.Option;
import com.google.common.base.Predicate;

public class InvitationServiceImpl
implements InvitationService {
    private final InviteUserTokenService inviteUserTokenService;
    private final DirectoryLocator directoryLocator;
    private static final Predicate<ExpirableUserToken> HAS_NOT_EXPIRED = new Predicate<ExpirableUserToken>(){

        public boolean apply(ExpirableUserToken expirableUserToken) {
            return System.currentTimeMillis() < expirableUserToken.getExpiryDate();
        }
    };

    public InvitationServiceImpl(InviteUserTokenService inviteUserTokenService, DirectoryLocator directoryLocator) {
        this.inviteUserTokenService = inviteUserTokenService;
        this.directoryLocator = directoryLocator;
    }

    @Override
    public String createAndStoreInviteToken(String recipient, int tokenExpirySeconds) throws ObjectAlreadyExistsException {
        ExpirableUserToken newExpirableToken = this.inviteUserTokenService.createAndStoreToken(recipient, this.directoryLocator.getDirectoryId(), tokenExpirySeconds);
        return newExpirableToken.getToken();
    }

    @Override
    public Option<ExpirableUserToken> getInvitation(String token) {
        Option<ExpirableUserToken> maybeExpirableUserToken = this.inviteUserTokenService.findByToken(token);
        return maybeExpirableUserToken.filter(HAS_NOT_EXPIRED);
    }

    @Override
    public void removeToken(String token) {
        this.inviteUserTokenService.removeToken(token);
    }
}

