/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.AdminLockEntity;
import com.atlassian.crowd.plugin.usermanagement.service.AdminLockService;
import com.atlassian.crowd.plugin.usermanagement.service.DirectoryLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminLockServiceImpl
implements AdminLockService {
    private final DirectoryManager directoryManager;
    private final DirectoryLocator directoryLocator;
    private static final Logger log = LoggerFactory.getLogger(AdminLockServiceImpl.class);

    public AdminLockServiceImpl(DirectoryManager directoryManager, DirectoryLocator directoryLocator) {
        this.directoryManager = directoryManager;
        this.directoryLocator = directoryLocator;
    }

    private boolean isInstanceLocked() {
        Directory directory = this.directoryLocator.getDirectory();
        return directory.getAttributes().containsKey("instance.admin.locked");
    }

    private String getLockedReason() {
        Directory directory = this.directoryLocator.getDirectory();
        return (String)directory.getAttributes().get("instance.admin.locked");
    }

    @Override
    public AdminLockEntity getLockedStatus() {
        return new AdminLockEntity(this.isInstanceLocked(), this.getLockedReason());
    }

    @Override
    public void lockAdmin(String reason) {
        log.info("Locking administration with the reason: " + reason);
        DirectoryImpl directory = new DirectoryImpl(this.directoryLocator.getDirectory());
        directory.setAttribute("instance.admin.locked", reason == null ? "" : reason);
        try {
            this.directoryManager.updateDirectory((Directory)directory);
        }
        catch (DirectoryNotFoundException dnfe) {
            throw new RuntimeException(dnfe);
        }
    }

    @Override
    public void unlockAdmin() {
        DirectoryImpl directory = new DirectoryImpl(this.directoryLocator.getDirectory());
        if (!this.isInstanceLocked()) {
            log.info("Attempted to unlock administration but it wasn't locked");
            return;
        }
        log.info("Unlocking administration");
        directory.removeAttribute("instance.admin.locked");
        try {
            this.directoryManager.updateDirectory((Directory)directory);
        }
        catch (DirectoryNotFoundException dnfe) {
            throw new RuntimeException(dnfe);
        }
    }
}

