/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.resource;

import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;

@Path(value="scmversion")
@AnonymousAllowed
public class ScmVersionResource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    public Response getVersion() {
        String gitPropertiesFileName = "/git.properties";
        InputStream in = this.getClass().getResourceAsStream(gitPropertiesFileName);
        if (in != null) {
            try {
                String gitRevision = IOUtils.toString(in).trim();
                Response response = ResponseFactory.ok(gitRevision).build();
                return response;
            }
            catch (IOException e) {
                Response response = ResponseFactory.serverError().build();
                return response;
            }
            finally {
                IOUtils.closeQuietly(in);
            }
        }
        return ResponseFactory.serverError().build();
    }
}

