/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.resource;

import com.atlassian.crowd.embedded.api.PasswordScore;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.ObjectAlreadyExistsException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.manager.mail.MailSendException;
import com.atlassian.crowd.model.token.ExpirableUserToken;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.util.LinkUriHelper;
import com.atlassian.crowd.plugin.usermanagement.rest.controller.SignupController;
import com.atlassian.crowd.plugin.usermanagement.rest.controller.UserController;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.InvitationEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.PublicSignUpFormEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.SignUpFormEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.EmailAlreadyExistsException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.EmailNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.LicenseExceededException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.MailServerConfigurationException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ProductAccessErrorException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.SignupNotEnabledException;
import com.atlassian.crowd.plugin.usermanagement.rest.resource.BaseResource;
import com.atlassian.crowd.plugin.usermanagement.rest.resource.SignupResponse;
import com.atlassian.crowd.plugin.usermanagement.service.PasswordPolicyService;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.fugue.Option;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.mail.internet.AddressException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.tanesha.recaptcha.ReCaptcha;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="signup")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
public class PublicSignUpResource
extends BaseResource {
    private static final Logger logger = LoggerFactory.getLogger(PublicSignUpResource.class);
    private final UserController userController;
    private final I18nResolver i18nResolver;
    private final SignupController signupController;
    private final ReCaptcha reCaptcha;
    private final PasswordPolicyService passwordPolicyService;

    public PublicSignUpResource(UserController userController, I18nResolver i18nResolver, SignupController signupController, ReCaptcha reCaptcha, PasswordPolicyService passwordPolicyService) {
        this.userController = userController;
        this.i18nResolver = i18nResolver;
        this.signupController = signupController;
        this.reCaptcha = reCaptcha;
        this.passwordPolicyService = passwordPolicyService;
    }

    @GET
    public Response getInvitationForToken(@QueryParam(value="token") String token) {
        Option<ExpirableUserToken> maybeExpirableUserToken;
        if (StringUtils.isNotBlank(token) && (maybeExpirableUserToken = this.userController.getInvitation(token)).isDefined()) {
            InvitationEntity invitationEntity = new InvitationEntity(((ExpirableUserToken)maybeExpirableUserToken.get()).getEmailAddress());
            PasswordScore policyScore = this.passwordPolicyService.getPolicyScore();
            return ResponseFactory.ok(new SignupResponse(invitationEntity, policyScore)).build();
        }
        return PublicSignUpResource.buildErrors(this.i18nResolver.getText("usermanagement.users.inviteuser.invalidtoken"));
    }

    @POST
    public Response signUpWithInviteToken(SignUpFormEntity signUpFormEntity) {
        HashMap errors = Maps.newHashMap();
        PublicSignUpResource.checkArgument(errors, StringUtils.isNotBlank(signUpFormEntity.getName()), "name", this.i18nResolver.getText("usermanagement.validation.username.missing"));
        PublicSignUpResource.checkArgument(errors, StringUtils.isNotBlank(signUpFormEntity.getDisplayName()), "display-name", this.i18nResolver.getText("usermanagement.validation.displayname.missing"));
        PublicSignUpResource.checkArgument(errors, signUpFormEntity.getPassword() != null, "password", this.i18nResolver.getText("usermanagement.validation.password.missing"));
        if (PublicSignUpResource.hasErrors(errors)) {
            return PublicSignUpResource.buildErrors(errors);
        }
        try {
            UserEntity createdUser = this.userController.addUserWithToken(signUpFormEntity, this.getBaseUri(), signUpFormEntity.getToken(), this.getBaseUri().getHost());
            URI location = LinkUriHelper.buildUserUri(this.getBaseUri(), createdUser.getName());
            return ResponseFactory.created(location).entity((Object)createdUser).build();
        }
        catch (LicenseExceededException e) {
            return ResponseFactory.status(Response.Status.BAD_REQUEST).entity((Object)ErrorEntity.withGenericError(this.i18nResolver.getText("usermanagement.signup.public.error.preamble") + "\n" + this.i18nResolver.getText("usermanagement.signup.public.error.license", new Serializable[]{PublicSignUpResource.getFirstKey(e.getInfo()).getProductName()}))).build();
        }
        catch (ProductAccessErrorException e) {
            logger.error("Exception trying to accept a signup invitation", (Throwable)e);
            return ResponseFactory.status(Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ErrorEntity.withGenericError(this.i18nResolver.getText("usermanagement.signup.public.error.preamble") + "\n" + this.i18nResolver.getText("usermanagement.signup.public.error.access", new Serializable[]{PublicSignUpResource.getFirstKey(e.getInfo()).getProductName()}))).build();
        }
        catch (UserAlreadyExistsException e) {
            return ResponseFactory.status(Response.Status.BAD_REQUEST).entity((Object)ErrorEntity.withGenericError(this.i18nResolver.getText("usermanagement.signup.public.error.nameTaken", new Serializable[]{e.getUserName()}))).build();
        }
        catch (Exception e) {
            logger.error("Very unexpected exception trying to accept a signup invitation", (Throwable)e);
            return ResponseFactory.status(Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ErrorEntity.withGenericError(this.i18nResolver.getText("usermanagement.signup.public.error.unexpected"))).build();
        }
    }

    private static <T> T getFirstKey(Map<T, ?> map) throws NoSuchElementException {
        return map.keySet().iterator().next();
    }

    @Path(value="public")
    @POST
    public Response selfInvite(PublicSignUpFormEntity publicSignUpFormEntity) throws DirectoryPermissionException, DirectoryNotFoundException, LicenseExceededException, InvalidCredentialException, OperationFailedException, InvalidUserException, ObjectAlreadyExistsException, SignupNotEnabledException, EmailNotAllowedException, UserNotFoundException, AddressException, MailServerConfigurationException, MailSendException, EmailAlreadyExistsException {
        HashMap errors = Maps.newHashMap();
        PublicSignUpResource.checkArgument(errors, this.reCaptcha.checkAnswer(this.getRemoteAddr(), publicSignUpFormEntity.getCaptchaChallenge(), publicSignUpFormEntity.getCaptchaResponse()).isValid(), "recaptcha_response_field", this.i18nResolver.getText("usermanagement.validation.captcha.invalid"));
        if (PublicSignUpResource.hasErrors(errors)) {
            return PublicSignUpResource.buildErrors(errors);
        }
        this.userController.selfInvite(publicSignUpFormEntity);
        return ResponseFactory.ok().build();
    }

    @GET
    @Path(value="enabled")
    public Response isSignupEnabled() {
        if (this.signupController.getSignupOptions().isSignupEnabled()) {
            return ResponseFactory.ok().build();
        }
        return ResponseFactory.status(Response.Status.NOT_FOUND).build();
    }
}

