/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.resource;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.plugin.usermanagement.rest.controller.ProductController;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ProductDefaultEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ProductEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ProductLicenseInfoEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.resource.BaseResource;
import com.atlassian.crowd.plugin.usermanagement.service.ProductService;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="apps")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ResourceFilters(value={AdminOnlyResourceFilter.class})
public class ProductsResource
extends BaseResource {
    private final ProductController productController;
    private final ProductService productService;

    public ProductsResource(ProductController productController, ProductService productService) {
        this.productController = productController;
        this.productService = productService;
    }

    @GET
    public Response getProducts() {
        List<Product> products = this.productService.fetchProducts();
        List<ProductEntity> productEntities = this.productController.getProducts(products);
        return ResponseFactory.ok(productEntities).build();
    }

    @GET
    @Path(value="/description")
    public Response getProductDescription() {
        return ResponseFactory.ok(this.productService.fetchProductDescription()).build();
    }

    @GET
    @Path(value="/seats")
    public Response getProductSeats() throws DirectoryNotFoundException, OperationFailedException, CredentialsRequiredException {
        List<Product> products = this.productService.fetchProducts();
        List<ProductLicenseInfoEntity> productEntities = this.productController.getProductLicenseEntities(products);
        return ResponseFactory.ok(productEntities).build();
    }

    @GET
    @Path(value="/defaults")
    public Response getDefaultProducts() {
        List<Product> products = this.productService.fetchProducts();
        Iterable<ProductDefaultEntity> productEntities = this.productController.getProductDefaults(products);
        return ResponseFactory.ok(productEntities).build();
    }

    @PUT
    @Path(value="/defaults")
    public Response setDefaultProducts(Map<String, Boolean> productDefaults) {
        Iterable<ProductDefaultEntity> productEntities = this.productController.updateProductDefaults(productDefaults);
        return ResponseFactory.ok(productEntities).build();
    }

    @GET
    @Path(value="/{appId}/users")
    public Response getUsersForProduct(@PathParam(value="appId") String productId, @DefaultValue(value="0") @QueryParam(value="start-index") int startIndex, @QueryParam(value="n") List<String> newUsersToPrepend, @DefaultValue(value="") @QueryParam(value="filter") String filter, @DefaultValue(value="50") @QueryParam(value="max-results") int maxResults) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        try {
            return ResponseFactory.ok(this.productController.getUsersWithAccessToProduct(filter, productId, startIndex, maxResults, newUsersToPrepend, this.getBaseUri())).build();
        }
        catch (CredentialsRequiredException e) {
            return ResponseFactory.status(Response.Status.UNAUTHORIZED).build();
        }
    }
}

