/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.resource;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.plugin.rest.entity.GroupEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntityList;
import com.atlassian.crowd.plugin.rest.util.EntityTranslator;
import com.atlassian.crowd.plugin.rest.util.LinkUriHelper;
import com.atlassian.crowd.plugin.usermanagement.rest.controller.GroupController;
import com.atlassian.crowd.plugin.usermanagement.rest.controller.UserController;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.GroupCountEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.RestGroupEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.GroupCannotBeDeletedException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.GroupMembershipChangeNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.LicenseExceededException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ProductAccessErrorException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.SysadminGroupModificationNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.UserModificationNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.UsersCausingLicenseException;
import com.atlassian.crowd.plugin.usermanagement.rest.resource.BaseResource;
import com.atlassian.crowd.plugin.usermanagement.rest.util.RestResources;
import com.atlassian.crowd.plugin.usermanagement.service.UserAndGroupService;
import com.atlassian.crowd.plugin.usermanagement.util.Constants;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.crowd.plugin.usermanagement.util.UserFunctions;
import com.atlassian.crowd.util.BoundedCount;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="group")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ResourceFilters(value={AdminOnlyResourceFilter.class})
public class GroupsResource
extends BaseResource {
    private final GroupController groupController;
    private final UserController userController;
    private final UserAndGroupService userAndGroupService;
    private I18nResolver i18nResolver;

    public GroupsResource(GroupController groupController, UserController userController, UserAndGroupService userAndGroupService, I18nResolver i18nResolver) {
        this.userAndGroupService = userAndGroupService;
        this.i18nResolver = i18nResolver;
        this.groupController = (GroupController)Preconditions.checkNotNull((Object)groupController);
        this.userController = (UserController)Preconditions.checkNotNull((Object)userController);
    }

    @GET
    public Response getGroup(@QueryParam(value="groupname") String groupName) throws GroupNotFoundException, DirectoryNotFoundException, OperationFailedException {
        RestResources.checkParam("groupname", groupName);
        RestGroupEntity groupEntity = this.groupController.getGroup(groupName, this.getBaseUri());
        return ResponseFactory.ok().entity((Object)groupEntity).build();
    }

    @GET
    @Path(value="count")
    public Response getDetailedGroup(@QueryParam(value="groupname") String groupName, @QueryParam(value="max-results") Integer userRequestMaxResults) throws GroupNotFoundException, DirectoryNotFoundException, OperationFailedException {
        RestResources.checkParam("groupname", groupName);
        int userMaxResults = userRequestMaxResults == null ? Constants.MAXIMUM_GROUP_COUNT_LIMIT : userRequestMaxResults;
        int suggestedMaxResults = Math.min(Constants.MAXIMUM_GROUP_COUNT_LIMIT, userMaxResults);
        BoundedCount membershipCount = this.userAndGroupService.countDirectMembersOfGroup(groupName, suggestedMaxResults);
        return ResponseFactory.ok().entity((Object)new GroupCountEntity(groupName, membershipCount)).build();
    }

    @GET
    @Path(value="search")
    public Response searchGroups(@QueryParam(value="filter") String filter, @DefaultValue(value="0") @QueryParam(value="start-index") int startIndex, @DefaultValue(value="50") @QueryParam(value="max-results") int maxResults) throws DirectoryNotFoundException, OperationFailedException {
        Iterable<RestGroupEntity> groups = this.groupController.findGroupsByName(filter, startIndex, maxResults, this.getBaseUri());
        return ResponseFactory.ok().entity(groups).build();
    }

    @POST
    public Response addGroup(GroupEntity group) throws InvalidGroupException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException {
        HashMap errors = Maps.newHashMap();
        GroupsResource.checkArgument(errors, group != null && StringUtils.isNotBlank(group.getName()), "name", this.i18nResolver.getText("usermanagement.validation.groupname.missing"));
        if (GroupsResource.hasErrors(errors)) {
            return GroupsResource.buildErrors(errors);
        }
        try {
            RestGroupEntity createdGroup = this.groupController.addGroup(group, this.getBaseUri());
            return ResponseFactory.created(LinkUriHelper.buildGroupUri(this.getBaseUri(), createdGroup.getName())).entity((Object)createdGroup).build();
        }
        catch (InvalidGroupException e) {
            return GroupsResource.buildErrors((Map<String, String>)ImmutableMap.of((Object)"name", (Object)this.i18nResolver.getText("usermanagement.validation.groupname.invalid")));
        }
    }

    @DELETE
    public Response deleteGroup(@QueryParam(value="groupname") String groupName) throws GroupNotFoundException, DirectoryNotFoundException, ReadOnlyGroupException, OperationFailedException, DirectoryPermissionException, GroupCannotBeDeletedException, SysadminGroupModificationNotAllowedException {
        RestResources.checkParam("groupname", groupName);
        this.userAndGroupService.deleteGroup(groupName);
        return ResponseFactory.noContent().build();
    }

    @PUT
    public Response updateGroup(@QueryParam(value="groupname") String groupName, GroupEntity group) throws InvalidGroupException, ReadOnlyGroupException, OperationFailedException, GroupNotFoundException, DirectoryNotFoundException, DirectoryPermissionException {
        if (!StringUtils.equalsIgnoreCase(groupName, group.getName())) {
            throw new InvalidGroupException((Group)EntityTranslator.toGroup(group), "The names of the resource location <" + this.getPath() + "> and object <" + group.getName() + "> are not equal");
        }
        RestGroupEntity updatedGroup = this.groupController.updateGroup(group, this.getBaseUri());
        return ResponseFactory.ok(updatedGroup).build();
    }

    @GET
    @Path(value="user/direct")
    public Response getDirectUsers(@QueryParam(value="groupname") String groupName, @DefaultValue(value="0") @QueryParam(value="start-index") int startIndex, @DefaultValue(value="50") @QueryParam(value="max-results") int maxResults, @QueryParam(value="n") List<String> newUserNamesToPrepend) throws DirectoryNotFoundException, OperationFailedException, UserNotFoundException {
        RestResources.checkParam("groupname", groupName);
        Iterable<UserEntity> users = this.userController.findUsersByGroup(groupName, startIndex, maxResults, newUserNamesToPrepend, this.getBaseUri());
        return ResponseFactory.ok(users).build();
    }

    @POST
    @Path(value="user/direct")
    public Response addDirectUsers(@QueryParam(value="groupname") String groupName, UserEntityList users) throws DirectoryPermissionException, DirectoryNotFoundException, GroupNotFoundException, UserNotFoundException, ReadOnlyGroupException, OperationFailedException, SysadminGroupModificationNotAllowedException, LicenseExceededException, ProductAccessErrorException, UsersCausingLicenseException, UserModificationNotAllowedException, GroupMembershipChangeNotAllowedException {
        RestResources.checkParam("groupname", groupName);
        ImmutableSet usernames = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)users, UserFunctions.userEntityNameGetter()));
        this.userAndGroupService.addUsersToGroup((Set<String>)usernames, groupName);
        return ResponseFactory.ok(users).build();
    }
}

