/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.exception.mapper;

import com.atlassian.crowd.plugin.usermanagement.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.GroupsCausingLicenseException;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.service.validation.MembershipChangeCausingLicenseExceeded;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.Serializable;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;

@Provider
public class GroupsCausingLicenseExceptionMapper
implements ExceptionMapper<GroupsCausingLicenseException> {
    private final I18nResolver i18nResolver;

    public GroupsCausingLicenseExceptionMapper(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public Response toResponse(GroupsCausingLicenseException e) {
        return ResponseFactory.status(Response.Status.BAD_REQUEST).entity((Object)ErrorEntity.withGenericError(Collections2.transform(e.getInfo().entrySet(), (Function)new Function<Map.Entry<Product, MembershipChangeCausingLicenseExceeded>, String>(){

            public String apply(Map.Entry<Product, MembershipChangeCausingLicenseExceeded> input) {
                return GroupsCausingLicenseExceptionMapper.this.i18nResolver.getText("usermanagement.membership.add.groups.license.exceeded.error", new Serializable[]{input.getKey().getProductName(), StringUtils.join(input.getValue().getGroupNames(), ", ")});
            }
        }))).build();
    }
}

