/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.exception.mapper;

import com.atlassian.crowd.plugin.usermanagement.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.EntityCannotBeDeletedException;
import com.atlassian.crowd.plugin.usermanagement.rest.util.I18nFunctions;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ValidationResults;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.ValidationMessageEntity;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class EntityCannotBeDeletedExceptionMapper
implements ExceptionMapper<EntityCannotBeDeletedException> {
    private final I18nResolver i18nResolver;

    public EntityCannotBeDeletedExceptionMapper(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public Response toResponse(EntityCannotBeDeletedException e) {
        ValidationResults validationResults = e.getValidationResults();
        ImmutableList messages = ImmutableList.builder().addAll(Iterables.transform(validationResults.getGenericErrors(), I18nFunctions.translate(this.i18nResolver))).addAll(Iterables.transform(validationResults.getApplicationErrors(), ValidationMessageEntity.getMessageFunction())).build();
        return ResponseFactory.status(Response.Status.CONFLICT).entity((Object)ErrorEntity.withGenericError((Iterable<String>)messages)).build();
    }
}

