/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.entity;

import com.atlassian.crowd.plugin.usermanagement.rest.entity.ProductValidationResultEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.ValidationMessageEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.ValidationResultEntity;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.annotate.JsonProperty;

public class ValidationResultsEntity
extends ValidationResultEntity {
    @JsonProperty
    private final Collection<ProductValidationResultEntity> references;
    private static final Predicate<ProductValidationResultEntity> HAS_ERROR_PREDICATE = new Predicate<ProductValidationResultEntity>(){

        public boolean apply(ProductValidationResultEntity input) {
            return input.hasErrors();
        }
    };

    public ValidationResultsEntity(List<ValidationMessageEntity> warnings, List<ValidationMessageEntity> errors, Collection<ProductValidationResultEntity> references) {
        super(warnings, errors);
        this.references = references;
    }

    public static ValidationResultsEntity error(ValidationMessageEntity singletonError) {
        return new ValidationResultsEntity(Collections.emptyList(), Collections.singletonList(singletonError), Collections.emptyList());
    }

    public static ValidationResultsEntity applicationResults(Collection<ProductValidationResultEntity> applicationValidationResults) {
        return new ValidationResultsEntity(Collections.emptyList(), Collections.emptyList(), applicationValidationResults);
    }

    @Override
    @JsonProperty
    public boolean hasErrors() {
        return super.hasErrors() || this.references != null && Iterables.any(this.references, HAS_ERROR_PREDICATE);
    }
}

