/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.entity;

import com.atlassian.crowd.plugin.usermanagement.rest.entity.ProductDefaultEntity;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ProductAccessError;
import com.atlassian.fugue.Option;
import java.net.URI;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class ProductLicenseInfoEntity {
    private final ProductDefaultEntity productDefaultEntity;
    private final Integer seatsAvailable;
    private final ProductAccessError error;
    private final Integer seatsTaken;
    private final Boolean isUnlimited;
    private final Boolean isPlatfomProduct;
    private final String platformProductName;

    public ProductLicenseInfoEntity(ProductLicenseInfoEntityBuilder builder) {
        this.productDefaultEntity = builder.productDefaultEntity;
        this.seatsAvailable = (Integer)builder.seatsAvailable.getOrNull();
        this.error = (ProductAccessError)builder.error.getOrNull();
        this.seatsTaken = (Integer)builder.seatsTaken.getOrNull();
        this.isUnlimited = (Boolean)builder.isUnlimited.getOrNull();
        this.isPlatfomProduct = builder.isPlatfomProduct;
        this.platformProductName = builder.platformProductName;
    }

    public ProductAccessError getError() {
        return this.error;
    }

    public Integer getSeatsAvailable() {
        return this.seatsAvailable;
    }

    public Integer getSeatsTaken() {
        return this.seatsTaken;
    }

    public boolean getIsDefault() {
        return this.productDefaultEntity.getIsDefault();
    }

    public String getId() {
        return this.productDefaultEntity.getId();
    }

    public String getName() {
        return this.productDefaultEntity.getName();
    }

    public String getDescription() {
        return this.productDefaultEntity.getDescription();
    }

    public URI getIconUrl() {
        return this.productDefaultEntity.getIconUrl();
    }

    public Boolean isUnlimited() {
        return this.isUnlimited;
    }

    public boolean isPlatformProduct() {
        return this.isPlatfomProduct;
    }

    public String getPlatformProductName() {
        return this.platformProductName;
    }

    public static ProductLicenseInfoEntityBuilder builder(ProductDefaultEntity productEntity) {
        return new ProductLicenseInfoEntityBuilder(productEntity);
    }

    public static class ProductLicenseInfoEntityBuilder {
        private final ProductDefaultEntity productDefaultEntity;
        private Option<ProductAccessError> error;
        private Option<Integer> seatsAvailable;
        private Option<Integer> seatsTaken;
        private Option<Boolean> isUnlimited;
        private Boolean isPlatfomProduct;
        private String platformProductName;

        public ProductLicenseInfoEntityBuilder(ProductDefaultEntity productDefaultEntity) {
            this.productDefaultEntity = productDefaultEntity;
            this.error = Option.none();
            this.seatsAvailable = Option.none();
            this.seatsTaken = Option.none();
            this.isUnlimited = Option.none();
            this.isPlatfomProduct = false;
            this.platformProductName = "";
        }

        public ProductLicenseInfoEntity build() {
            return new ProductLicenseInfoEntity(this);
        }

        public ProductLicenseInfoEntityBuilder withError(Option<ProductAccessError> error) {
            this.error = error;
            return this;
        }

        public ProductLicenseInfoEntityBuilder withSeatsAvailable(Option<Integer> seatsAvailable) {
            this.seatsAvailable = seatsAvailable;
            return this;
        }

        public ProductLicenseInfoEntityBuilder withSeatsTaken(Option<Integer> seatsTaken) {
            this.seatsTaken = seatsTaken;
            return this;
        }

        public ProductLicenseInfoEntityBuilder withIsUnlimited(Option<Boolean> isUnlimited) {
            this.isUnlimited = isUnlimited;
            return this;
        }

        public ProductLicenseInfoEntityBuilder withPlatformProduct(String productName) {
            this.platformProductName = productName;
            return this;
        }

        public ProductLicenseInfoEntityBuilder withIsPlatformProduct(boolean isPlatformProduct) {
            this.isPlatfomProduct = isPlatformProduct;
            return this;
        }
    }
}

