/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.entity;

import com.atlassian.crowd.plugin.usermanagement.rest.entity.ProductEntity;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.service.products.ProductConfig;
import java.net.URI;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class ProductDefaultEntity {
    private final ProductEntity productEntity;
    private final boolean isDefault;
    private boolean isPlatformProduct;
    private String platformProductName;

    public ProductDefaultEntity(ProductEntity productEntity, boolean isDefault, Product product) {
        this.productEntity = productEntity;
        this.isDefault = isDefault;
        this.isPlatformProduct = false;
        this.platformProductName = "";
        if (product.hasProductConfig().booleanValue()) {
            ProductConfig config = (ProductConfig)product.fetchProductConfig().right().get();
            if (config.isPlatformProduct().booleanValue()) {
                this.isPlatformProduct = true;
            } else if (!config.getPlatformProductName().equals(product.getProductId())) {
                this.platformProductName = config.getPlatformProductName();
            }
        }
    }

    public boolean getIsDefault() {
        return this.isDefault;
    }

    public String getId() {
        return this.productEntity.getId();
    }

    public String getName() {
        return this.productEntity.getName();
    }

    public String getDescription() {
        return this.productEntity.getDescription();
    }

    public URI getIconUrl() {
        return this.productEntity.getIconUrl();
    }

    public boolean isPlatformProduct() {
        return this.isPlatformProduct;
    }

    public String getPlatformProductName() {
        return this.platformProductName;
    }
}

