/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.controller;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.util.LinkUriHelper;
import com.atlassian.crowd.plugin.rest.util.UserEntityUtil;
import com.atlassian.crowd.plugin.usermanagement.rest.controller.BaseController;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ListViewUser;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.LozengeEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ProductDefaultEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ProductEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ProductLicenseInfoEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.SeatsEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.util.MessageHelper;
import com.atlassian.crowd.plugin.usermanagement.service.DirectoryLocator;
import com.atlassian.crowd.plugin.usermanagement.service.ProductId;
import com.atlassian.crowd.plugin.usermanagement.service.ProductService;
import com.atlassian.crowd.plugin.usermanagement.service.UserAndGroupCheckService;
import com.atlassian.crowd.plugin.usermanagement.service.UserProvisioningService;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.service.products.ProductConfig;
import com.atlassian.crowd.plugin.usermanagement.service.products.ProductUtils;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ProductAccessError;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.AccessLevel;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.ProductUsageEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.UsageHostEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.UsageHostsEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.UsageProductEntity;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.Message;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(ProductController.class);
    private final DirectoryManager directoryManager;
    private final UserProvisioningService userProvisioningService;
    private final UserAndGroupCheckService userAndGroupCheckService;
    private final ProductService productService;

    public ProductController(DirectoryLocator directoryLocator, DirectoryManager directoryManager, I18nResolver i18nResolver, UserProvisioningService userProvisioningService, UserAndGroupCheckService userAndGroupCheckService, ProductService productService) {
        super(directoryLocator, i18nResolver);
        this.directoryManager = directoryManager;
        this.userProvisioningService = userProvisioningService;
        this.userAndGroupCheckService = userAndGroupCheckService;
        this.productService = productService;
    }

    public List<ProductLicenseInfoEntity> getProductLicenseEntities(List<Product> products) throws DirectoryNotFoundException, OperationFailedException, CredentialsRequiredException {
        ImmutableList.Builder licenseListBuilder = ImmutableList.builder();
        for (ProductDefaultEntity application : this.getProductDefaults(products)) {
            ProductLicenseInfoEntity.ProductLicenseInfoEntityBuilder licenseBuilder = ProductLicenseInfoEntity.builder(application);
            Either<ProductAccessError, SeatsEntity> errorOrAvailableSeats = this.getSeatsEntityForProduct(application.getId());
            if (errorOrAvailableSeats.isRight()) {
                SeatsEntity seatsEntity = (SeatsEntity)errorOrAvailableSeats.right().get();
                licenseBuilder.withSeatsTaken(Option.some(seatsEntity.getUsed())).withSeatsAvailable(seatsEntity.getAvailable()).withIsUnlimited(Option.some(seatsEntity.isUnlimited())).withIsPlatformProduct(application.isPlatformProduct()).withPlatformProduct(application.getPlatformProductName());
            } else {
                licenseBuilder.withError(errorOrAvailableSeats.left().toOption());
            }
            licenseListBuilder.add((Object)licenseBuilder.build());
        }
        return licenseListBuilder.build();
    }

    public List<ProductUsageEntity> getProductUsage() throws DirectoryNotFoundException, OperationFailedException, CredentialsRequiredException {
        List<Product> products = this.productService.fetchProducts();
        List<ProductLicenseInfoEntity> productLicenseInfoEntities = this.getProductLicenseEntities(products);
        List productUsageList = Lists.transform(productLicenseInfoEntities, (Function)new Function<ProductLicenseInfoEntity, ProductUsageEntity>(){

            public ProductUsageEntity apply(ProductLicenseInfoEntity productLicenseInfoEntity) {
                if (productLicenseInfoEntity.getError() == null) {
                    return new ProductUsageEntity(productLicenseInfoEntity.getName().toUpperCase(), productLicenseInfoEntity.getSeatsTaken());
                }
                return new ProductUsageEntity(productLicenseInfoEntity.getName().toUpperCase(), productLicenseInfoEntity.getError().getReason());
            }
        });
        return productUsageList;
    }

    public UsageHostsEntity getUsageHostsEntity() throws DirectoryNotFoundException, OperationFailedException, CredentialsRequiredException {
        ImmutableListMultimap productsByHostType = Multimaps.index(this.productService.fetchProducts(), ProductUtils.PRODUCT_TO_HOST_TYPE);
        Iterable hostUsage = Iterables.transform((Iterable)productsByHostType.asMap().entrySet(), (Function)new Function<Map.Entry<String, Collection<Product>>, UsageHostEntity>(){

            public UsageHostEntity apply(@Nullable Map.Entry<String, Collection<Product>> input) {
                Iterable hostProducts = Iterables.transform((Iterable)input.getValue(), (Function)new Function<Product, UsageProductEntity>(){

                    public UsageProductEntity apply(@Nullable Product product) {
                        return ProductController.this.generateUsageEntity(product);
                    }
                });
                return new UsageHostEntity(input.getKey(), (List<UsageProductEntity>)ImmutableList.copyOf((Iterable)hostProducts));
            }
        });
        return new UsageHostsEntity((List<UsageHostEntity>)ImmutableList.copyOf((Iterable)hostUsage));
    }

    private UsageProductEntity generateUsageEntity(Product product) {
        if (product.hasProductConfig().booleanValue()) {
            try {
                Set<String> usernamesWithSeats = this.userProvisioningService.findUsernamesTakingLicenseSeatsToProduct(product);
                return new UsageProductEntity(product.getProductKey(), product.getProductName(), usernamesWithSeats, null);
            }
            catch (CrowdException e) {
                logger.warn("Unable to find usernames granted to product", (Throwable)e);
                return new UsageProductEntity(product.getProductKey(), product.getProductName(), null, this.i18nResolver.getText("usermanagement.apps.could.load.individual.product.seats", new Serializable[]{product.getProductKey()}));
            }
        }
        return new UsageProductEntity(product.getProductKey(), product.getProductName(), null, this.i18nResolver.getText("usermanagement.apps.product.config.not.available", new Serializable[]{product.getProductKey()}));
    }

    public Iterable<ProductDefaultEntity> getProductDefaults(List<Product> products) {
        return Iterables.transform(this.userProvisioningService.getProductDefaults(products).entrySet(), (Function)new Function<Map.Entry<Product, Boolean>, ProductDefaultEntity>(){

            public ProductDefaultEntity apply(Map.Entry<Product, Boolean> entry) {
                return ProductController.this.newProductDefaultsEntity(entry.getKey(), entry.getValue());
            }
        });
    }

    private ProductDefaultEntity newProductDefaultsEntity(Product product, boolean isDefault) {
        return new ProductDefaultEntity(product.getProductEntity(this.i18nResolver), isDefault, product);
    }

    public Iterable<ProductDefaultEntity> updateProductDefaults(Map<String, Boolean> productIds) {
        List<Product> products = this.productService.fetchProducts();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String productId : productIds.keySet()) {
            Option<Product> maybeProduct = this.productService.getProduct(products, new ProductId(productId));
            for (Product product : maybeProduct) {
                builder.put((Object)product, (Object)productIds.get(productId));
            }
        }
        this.userProvisioningService.updateProductDefaults((Map<Product, Boolean>)builder.build());
        return this.getProductDefaults(products);
    }

    public List<ProductEntity> getProducts(List<Product> products) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(products, (Function)new Function<Product, ProductEntity>(){

            public ProductEntity apply(@Nullable Product input) {
                return input.getProductEntity(ProductController.this.i18nResolver);
            }
        }));
    }

    private Either<ProductAccessError, SeatsEntity> getSeatsEntityForProduct(String productId) throws DirectoryNotFoundException, OperationFailedException {
        Option<Product> maybeProduct = this.productService.getProduct(new ProductId(productId));
        if (maybeProduct.isDefined()) {
            Product product = (Product)maybeProduct.get();
            Either<ProductAccessError, ProductConfig> maybeConfig = product.fetchProductConfig();
            if (maybeConfig.isRight()) {
                return Either.right(this.userProvisioningService.getSeatsEntityForProduct(product));
            }
            return Either.left(maybeConfig.left().get());
        }
        return Either.left(new ProductAccessError(this.i18nResolver.getText("usermanagement.apps.notfound.error", new Serializable[]{productId})));
    }

    public Collection<UserEntity> getUsersWithAccessToProduct(String filter, String productId, int startIndex, int maxResults, List<String> usernamesToPrepend, URI baseUri) throws CredentialsRequiredException, DirectoryNotFoundException, OperationFailedException, UserNotFoundException {
        Preconditions.checkArgument((startIndex >= 0 ? 1 : 0) != 0, (Object)"Starting index must not be negative.");
        Preconditions.checkArgument((maxResults > 0 ? 1 : 0) != 0, (Object)"Maximum result must be positive.");
        Preconditions.checkNotNull((Object)filter, (Object)"Filter must not be null.");
        List<Product> products = this.productService.fetchProducts();
        Option<Product> maybeProduct = this.productService.getProduct(products, new ProductId(productId));
        if (maybeProduct.isDefined()) {
            Product product = (Product)maybeProduct.get();
            Object users = this.userProvisioningService.findUsersGrantedAccessToProduct(product);
            users = ProductController.rearrangeUsers(usernamesToPrepend).immutableSortedCopy(users);
            users = Iterables.filter((Iterable)users, ProductController.userIsActive());
            users = Iterables.filter((Iterable)users, ProductController.userMatchesFilter(filter));
            users = Iterables.skip((Iterable)users, (int)startIndex);
            users = Iterables.limit((Iterable)users, (int)maxResults);
            ImmutableList.Builder builder = ImmutableList.builder();
            Iterator i$ = users.iterator();
            while (i$.hasNext()) {
                User user = (User)i$.next();
                String username = user.getName();
                UserWithAttributes userWithAttributes = this.directoryManager.findUserWithAttributesByName(this.getDirectoryId(), username);
                UserEntity userEntity = UserEntityUtil.translateWithAttributes((com.atlassian.crowd.model.user.User)userWithAttributes, (Attributes)userWithAttributes, LinkUriHelper.buildUserLink(baseUri, username));
                Map<String, AccessLevel> accessLevels = this.translateAccessLevelRepresentation(this.userProvisioningService.getAccessLevel(username, products));
                Option<Message> dataMessage = this.userAndGroupCheckService.canCurrentUserModifyUserData(username);
                Option<Message> accessMessage = this.userAndGroupCheckService.canCurrentUserModifyUserAccess(username);
                String unableToModifyReason = MessageHelper.getDisabledMessage(accessMessage, dataMessage, this.i18nResolver);
                LozengeEntity lozenge = this.userAndGroupCheckService.getUserLozenge(userEntity).getOrNull();
                boolean isCurrentUser = this.userAndGroupCheckService.isCurrentUser(username);
                builder.add((Object)new ListViewUser(userEntity, accessLevels, accessMessage.isDefined(), dataMessage.isDefined(), unableToModifyReason, lozenge, isCurrentUser));
            }
            return builder.build();
        }
        return ImmutableList.of();
    }

    @VisibleForTesting
    static Ordering<User> rearrangeUsers(final List<String> usernamesToPrepend) {
        return Ordering.explicit(usernamesToPrepend).nullsLast().onResultOf((Function)new Function<User, String>(){

            public String apply(User user) {
                String name = user.getName();
                return usernamesToPrepend.contains(name) ? name : null;
            }
        });
    }

    private static <T extends User> Predicate<T> userMatchesFilter(String filter) {
        if (filter.isEmpty()) {
            return Predicates.alwaysTrue();
        }
        final String normalisedFilter = filter.trim().toLowerCase();
        return new Predicate<T>(){

            public boolean apply(T user) {
                return StringUtils.containsIgnoreCase(user.getEmailAddress(), normalisedFilter) || StringUtils.containsIgnoreCase(user.getDisplayName(), normalisedFilter) || StringUtils.containsIgnoreCase(user.getName(), normalisedFilter);
            }
        };
    }

    private static <T extends User> Predicate<T> userIsActive() {
        return new Predicate<T>(){

            public boolean apply(T user) {
                return user.isActive();
            }
        };
    }
}

