/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.filters;

import com.atlassian.crowd.plugin.usermanagement.service.AdminLockService;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AdminLockFilter
implements Filter {
    protected final AdminLockService adminLockService;
    protected final UserManager userManager;
    private static final Logger log = LoggerFactory.getLogger(AdminLockFilter.class);

    public AdminLockFilter(AdminLockService adminLockService, UserManager userManager) {
        this.adminLockService = adminLockService;
        this.userManager = userManager;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.shouldBlockRequest(request)) {
            log.debug("Denying a request because user management admin is locked - request to: " + ((HttpServletRequest)request).getRequestURL());
            this.returnError(response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    protected boolean shouldBlockRequest(ServletRequest request) {
        if (this.requestIsWhiteListed(request)) {
            return false;
        }
        return this.adminLockService.getLockedStatus().isLocked() && !this.isUserSysadmin();
    }

    protected boolean requestIsWhiteListed(ServletRequest request) {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        return "/rest/um/1".equals(servletRequest.getServletPath()) && "/lock".equals(servletRequest.getPathInfo());
    }

    protected abstract void returnError(ServletResponse var1) throws IOException;

    protected boolean isUserSysadmin() {
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null) {
            return false;
        }
        return this.userManager.isSystemAdmin(user.getUsername());
    }
}

