/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.constraints;

import com.atlassian.crowd.plugin.usermanagement.constraints.DomainNames;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.net.InternetDomainName;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class DomainNamesValidator
implements ConstraintValidator<DomainNames, Iterable<String>> {
    private static final Predicate<String> VALID_INTERNET_DOMAIN_NAME = new Predicate<String>(){

        public boolean apply(String domain) {
            return InternetDomainName.isValid((String)domain);
        }
    };

    public void initialize(DomainNames annotation) {
    }

    public boolean isValid(Iterable<String> strings, ConstraintValidatorContext constraintValidatorContext) {
        return strings == null || Iterables.all(strings, VALID_INTERNET_DOMAIN_NAME);
    }
}

