/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;

public final class UriBuilder {
    private final javax.ws.rs.core.UriBuilder delegate;
    private final LinkedListMultimap<String, Object> params = LinkedListMultimap.create();

    public static UriBuilder fromPath(String path) {
        return new UriBuilder(javax.ws.rs.core.UriBuilder.fromPath((String)path));
    }

    public static UriBuilder fromUri(String uri) {
        return new UriBuilder(javax.ws.rs.core.UriBuilder.fromUri((String)uri));
    }

    private UriBuilder(javax.ws.rs.core.UriBuilder delegate) {
        this.delegate = delegate;
    }

    public UriBuilder path(String path) {
        this.delegate.path(path);
        return this;
    }

    public UriBuilder queryParam(String name, Object ... values) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name is null");
        Preconditions.checkArgument((values != null && !Arrays.asList(values).contains(null) ? 1 : 0) != 0, (Object)"one or more of the values are null");
        this.params.putAll((Object)name, (Iterable)ImmutableList.copyOf((Object[])values));
        return this;
    }

    public URI build() {
        int paramCount = 0;
        javax.ws.rs.core.UriBuilder builder = javax.ws.rs.core.UriBuilder.fromUri((URI)this.delegate.build(new Object[0]));
        for (Map.Entry param : this.params.entries()) {
            builder.queryParam((String)param.getKey(), new Object[]{String.format("{%d}", paramCount++)});
        }
        return builder.build(this.params.values().toArray(new Object[this.params.values().size()]));
    }

    public String toString() {
        return this.build().toString();
    }
}

