/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.adminchrome.servlet;

import com.atlassian.crowd.plugin.adminchrome.util.ConfigurationTagBuilder;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.util.license.LicensedApplicationSource;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CrowdBootstrapServlet
extends HttpServlet {
    private static final String UNIFIED_ADMIN_CHROME_KEY = "com.atlassian.crowd.unified-admin-chrome";
    private static final String UNIFIED_ADMIN_CHROME_TEMPLATE_KEY = "com.atlassian.crowd.unified-admin-chrome:admin-chrome-template";
    private static final String UNIFIED_ADMIN_CHROME_SOY_TEMPLATE = "adminchrome.bootstrapStandalone";
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final I18nHelper i18nHelper;
    private final WebResourceManager webResourceManager;
    private final ConfigurationTagBuilder configurationTagBuilder;
    private final DarkFeatureManager darkFeatureManager;
    private final UserManager userManager;
    private LicensedApplicationSource licensedApplicationSource;

    public CrowdBootstrapServlet(SoyTemplateRenderer soyTemplateRenderer, I18nHelper i18nHelper, WebResourceManager webResourceManager, ConfigurationTagBuilder configurationTagBuilder, DarkFeatureManager darkFeatureManager, UserManager userManager, LicensedApplicationSource licensedApplicationSource) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.i18nHelper = i18nHelper;
        this.webResourceManager = webResourceManager;
        this.configurationTagBuilder = configurationTagBuilder;
        this.darkFeatureManager = darkFeatureManager;
        this.userManager = userManager;
        this.licensedApplicationSource = licensedApplicationSource;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.webResourceManager.requireResourcesForContext("atl.admin");
        this.webResourceManager.requireResourcesForContext("atl.unified.admin");
        StringWriter writer = new StringWriter();
        this.webResourceManager.includeResources((Writer)writer, UrlMode.AUTO);
        resp.setContentType("text/html");
        resp.setCharacterEncoding("UTF-8");
        UserProfile user = this.userManager.getRemoteUser();
        ImmutableMap properties = ImmutableMap.builder().put((Object)"applicationName", (Object)this.i18nHelper.getText("usermanagement.application.user.management")).put((Object)"logoutUrl", (Object)"/logout").put((Object)"contextPath", (Object)req.getContextPath()).put((Object)"umServletPath", (Object)"/plugins/servlet/um").put((Object)"horde", (Object)false).put((Object)"additionalStaticResources", (Object)this.configurationTagBuilder.get()).put((Object)"webResources", (Object)writer.toString()).put((Object)"enabledDarkFeatures", (Object)this.darkFeatureManager.getFeaturesEnabledForAllUsers().getFeatureKeys()).put((Object)"remoteUserFullName", (Object)(user != null ? user.getFullName() : "")).build();
        try {
            this.soyTemplateRenderer.render((Appendable)resp.getWriter(), UNIFIED_ADMIN_CHROME_TEMPLATE_KEY, UNIFIED_ADMIN_CHROME_SOY_TEMPLATE, (Map)properties);
        }
        catch (SoyException e) {
            throw new RuntimeException(e);
        }
    }
}

