/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.adminchrome.rest.resource;

import com.atlassian.crowd.plugin.adminchrome.data.httpjson.registryurl.ComponentRegistryUrlManager;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.google.common.base.Preconditions;
import com.sun.jersey.spi.container.ResourceFilters;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Consumes(value={"text/plain"})
@Produces(value={"text/plain"})
@Path(value="componentRegistry/override")
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
public class ComponentRegistryUrlOverrideResource {
    private final ComponentRegistryUrlManager urlOverrideManager;

    public ComponentRegistryUrlOverrideResource(ComponentRegistryUrlManager urlOverrideManager) {
        this.urlOverrideManager = urlOverrideManager;
    }

    @GET
    public Response getRegistryUrlOverride() {
        return Response.ok((Object)this.urlOverrideManager.getComponentRegistryUrlOverride()).build();
    }

    @PUT
    public Response setComponent(String componentRegistryUrlOverride) {
        Preconditions.checkNotNull((Object)StringUtils.stripToNull(componentRegistryUrlOverride), (Object)"componentRegistryUrlOverride must not be null");
        this.urlOverrideManager.setComponentRegistryUrlOverride(componentRegistryUrlOverride);
        return Response.noContent().build();
    }

    @DELETE
    public Response removeOverride() {
        this.urlOverrideManager.removeComponentRegistryUrlOverride();
        return Response.noContent().build();
    }
}

