/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.adminchrome.data.httpjson;

import com.atlassian.crowd.plugin.adminchrome.data.ComponentEntry;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
public class HttpJsonComponentEntry
implements ComponentEntry {
    private final String name;
    private final String version;
    private final String location;
    private final boolean visible;
    private final List<String> jsResources;
    private final List<String> cssResources;

    @JsonCreator
    public HttpJsonComponentEntry(@JsonProperty(value="name") @Nonnull String name, @JsonProperty(value="version") String version, @JsonProperty(value="location") String location, @JsonProperty(value="visible") boolean visible, @JsonProperty(value="jsResources") List<String> jsResources, @JsonProperty(value="cssResources") List<String> cssResources) {
        this.name = name;
        this.version = version;
        this.location = location;
        this.visible = visible;
        this.jsResources = jsResources != null ? ImmutableList.copyOf(jsResources) : ImmutableList.of();
        this.cssResources = cssResources != null ? ImmutableList.copyOf(cssResources) : ImmutableList.of();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public List<String> getJsResources() {
        return this.jsResources;
    }

    @Override
    public List<String> getCssResources() {
        return this.cssResources;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof HttpJsonComponentEntry)) {
            return false;
        }
        HttpJsonComponentEntry that = (HttpJsonComponentEntry)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

