/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="test-user")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class UserResourcesForTests {
    private final DirectoryManager directoryManager;
    private static final String DEFAULT_CROWD_DIRECTORY_NAME = System.getProperty("horde.ondemand.directory.name", "Studio Crowd");

    public UserResourcesForTests(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    @POST
    @Path(value="attribute")
    public Response setUserAttribute(@QueryParam(value="username") String username, @QueryParam(value="key") String key, @QueryParam(value="value") String value) throws UserNotFoundException, DirectoryNotFoundException, OperationFailedException, DirectoryPermissionException {
        this.directoryManager.storeUserAttributes(this.getDirectoryId().longValue(), username, (Map)ImmutableMap.of((Object)key, (Object)ImmutableSet.of((Object)value)));
        return Response.ok().build();
    }

    @POST
    @Path(value="create")
    public Response createBulkUsers(@QueryParam(value="baseUsername") String baseUsername, @QueryParam(value="startNumber") int startNumber, @QueryParam(value="endNumber") int endNumber, @QueryParam(value="groups") List<String> groups) throws DirectoryNotFoundException, GroupNotFoundException, DirectoryPermissionException, OperationFailedException {
        long directoryId = this.getDirectoryId();
        List<String> usernames = this.generateUsernames(startNumber, endNumber, baseUsername);
        this.directoryManager.addAllUsers(directoryId, this.generateUsers(usernames, directoryId), false);
        for (String group : groups) {
            this.directoryManager.addAllUsersToGroup(directoryId, usernames, group);
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="delete")
    public Response deleteBulkUsers(@QueryParam(value="baseUsername") String baseUsername, @QueryParam(value="startNumber") int startNmber, @QueryParam(value="endNumber") int endNumber) throws DirectoryNotFoundException, UserNotFoundException, DirectoryPermissionException, OperationFailedException {
        long directoryId = this.getDirectoryId();
        List<String> usernames = this.generateUsernames(startNmber, endNumber, baseUsername);
        for (String user : usernames) {
            this.directoryManager.removeUser(directoryId, user);
        }
        return Response.ok().build();
    }

    private Long getDirectoryId() throws DirectoryNotFoundException {
        return this.directoryManager.findDirectoryByName(DEFAULT_CROWD_DIRECTORY_NAME).getId();
    }

    private List<String> generateUsernames(int startNumber, int endNumber, String baseUsername) {
        ImmutableList.Builder usernameBuilder = ImmutableList.builder();
        for (int i = startNumber; i < endNumber; ++i) {
            usernameBuilder.add((Object)(baseUsername + i));
        }
        return usernameBuilder.build();
    }

    private List<UserTemplateWithCredentialAndAttributes> generateUsers(List<String> usernames, Long directoryId) {
        ImmutableList.Builder userBuilder = ImmutableList.builder();
        for (String username : usernames) {
            UserTemplateWithCredentialAndAttributes user = new UserTemplateWithCredentialAndAttributes(username, directoryId.longValue(), PasswordCredential.unencrypted((String)"superLongPasswordThatWillPassAnyPolicy!Wow!"));
            user.setActive(true);
            userBuilder.add((Object)user);
        }
        return userBuilder.build();
    }
}

