window.UserManagement = window.UserManagement || {};
window.UserManagement.routes = window.UserManagement.routes || {};
window.UserManagement.routes.users = window.UserManagement.routes.users || {};
window.UserManagement.routes.users.messages = window.UserManagement.routes.users.messages || {};
window.UserManagement.routes.users.messages.license = window.UserManagement.routes.users.messages.license || {};

(function ($, license) {
    var sortLicenseTiersByMaxUsers = function (licenseTiers) {
        var copyOfLicenseTiers = $.extend(true, [], licenseTiers);
        copyOfLicenseTiers.sort(function (a, b) {
            return a.maxUsers - b.maxUsers
        });
        return copyOfLicenseTiers;
    };

    var findLicenseUsageForProduct = function (licenseUsages, productName) {
        var isLicenseUsageForProduct = function (licenseUsage) {
            return getProductName(licenseUsage) === productName;
        };

        return $.grep(licenseUsages, isLicenseUsageForProduct)[0] || {};
    };

    var getLicenseTierIndexForUsage = function (licenseTiersSortedByMaxUsers, licenseUsage) {
        var isSeatsTakenInLicenseTier = function (licenseTier) {
            var tierIsForThisProduct = (licenseTier.productName === getProductName(licenseUsage));
            var usageIsOnOrAboveLowerLimit = (licenseUsage.seatsTaken >= licenseTier.minUsers);
            var usageIsOnOrBelowUpperLimit = (licenseUsage.seatsTaken <= licenseTier.maxUsers);
            return tierIsForThisProduct && usageIsOnOrAboveLowerLimit && usageIsOnOrBelowUpperLimit;
        };

        var matchingLicenseTiers = $.grep(licenseTiersSortedByMaxUsers, isSeatsTakenInLicenseTier);
        return licenseTiersSortedByMaxUsers.indexOf(matchingLicenseTiers[0]);
    };

    var getProductName = function (licenseUsage) {
        return (licenseUsage.description || '').toLowerCase();
    };

    var hasNewUsageIncreasedTheTier = function (oldLicenseUsage, newLicenseUsage, licenseTiersSortedByMaxUsers) {
        var oldLicenseTierIndex = getLicenseTierIndexForUsage(licenseTiersSortedByMaxUsers, oldLicenseUsage);
        var newLicenseTierIndex = getLicenseTierIndexForUsage(licenseTiersSortedByMaxUsers, newLicenseUsage);

        var oldLicenseTierFound = oldLicenseTierIndex > -1;
        var licenseUsageIncreased = newLicenseTierIndex > oldLicenseTierIndex;

        return !oldLicenseUsage.unlimited && oldLicenseTierFound && licenseUsageIncreased;
    };

    /**
     * @param options.licenseTiers
     * @param options.newLicenseUsages
     * @param options.oldLicenseUsages
     */
    license.hasLicenseTierIncreased = function (options) {
        var licenseTiersSortedByMaxUsers = sortLicenseTiersByMaxUsers(options.licenseTiers);

        var hasTierIncreasedForLicense = function (oldLicenseUsage) {
            var newLicenseUsage = findLicenseUsageForProduct(options.newLicenseUsages, getProductName(oldLicenseUsage));
            return hasNewUsageIncreasedTheTier(oldLicenseUsage, newLicenseUsage, licenseTiersSortedByMaxUsers);
        };

        var productsWhoseLicenseTierHasIncreased = $.grep(options.oldLicenseUsages, hasTierIncreasedForLicense);
        return productsWhoseLicenseTierHasIncreased.length > 0;
    };
}(AJS.$, window.UserManagement.routes.users.messages.license));