window.UserManagement = window.UserManagement || {};
window.UserManagement.routes = window.UserManagement.routes || {};
window.UserManagement.routes.users = window.UserManagement.routes.users || {};
window.UserManagement.routes.users.messages = window.UserManagement.routes.users.messages || {};

(function ($, messages) {
    /**
     * @param options.oldLicenseUsages
     * @param options.users
     * @param options.isAutoUpgradeModeEnabled
     */
    messages.displayUserSuccessfullyAddedMessage = function (options) {
        var isAutoUpgradeModeEnabled = function () {
            var deferred = $.Deferred();
            options.isAutoUpgradeModeEnabled ? deferred.resolve() : deferred.reject();
            return deferred.promise();
        };

        var calculateHasLicenseTierIncreased = function (newLicenseUsages) {
            return messages.license.hasLicenseTierIncreased({
                licenseTiers: messages.tiers.getLicenseTiers(),
                newLicenseUsages: newLicenseUsages,
                oldLicenseUsages: options.oldLicenseUsages
            });
        };

        var assumeHasLicenseTierIncreasedIsFalse = function () {
            return $.when(false)
        };

        var renderSuccessMessage = function (hasLicenseTierIncreased) {
            var users = options.users || [options.user];
            var emailSent = options.emailSent;
            messages.renderer.renderSuccessMessage({
                hasMovedToNewTier: hasLicenseTierIncreased,
                users: users,
                emailSent: emailSent
            });
        };

        return isAutoUpgradeModeEnabled()
                .then(window.UserManagement.helpers.ajax.getApplicationWithSeats)
                .then(calculateHasLicenseTierIncreased, assumeHasLicenseTierIncreasedIsFalse)
                .then(renderSuccessMessage);
    };
}(AJS.$, window.UserManagement.routes.users.messages));