require(['aui/form-notification']);

(function ($, root, adminApp) {
    var INVITE_EXPIRY_STORAGE_KEY = 'uum.invite.expiryDays';
    var DEFAULT_INVITE_EXPIRY = 7;
    var AID_INTEGRATION_FEATURE_KEY = "um.aid.integration";
    var CREATE_ANOTHER_STORAGE_KEY = "create-another";

    var ignoredFields = [
        'send-notification',
        'create-another'
    ];

    // IE doesn't support location.origin
    location.origin = location.origin || (location.protocol + "//" + location.host);

    root.routes = root.routes || {};
    root.routes.users = root.routes.users || {};
    var userRoutes = root.routes.users;
    var helpers = root.helpers;
    var manipulation = root.manipulation;

    userRoutes.list = function (params) {
        // Render actions bar - where search etc is
        helpers.updateContent(usermanagement.users.actions());

        var $actions = $("#dataActions")
            .removeClass("hidden")
            .on("change", "#user-types", function () {
                dataTable.search();
            })
            .on("change", "#user-active-filter", function () {
                if (dataTable) {
                    dataTable.search();
                }
            });

        helpers.users.setupUserFilter($actions.find("form"));
        helpers.users.setupActiveFilter($actions.find("form"));

        // Render data table with list of users
        var dataTable = new root.UMDataTable(params.type, {
            searchTriggerContainer: "#users-list-search",
            parse: userRoutes.sanitiseUserData,
            container: params.container,
            loadedCallback: function() {
                dataTable.hideBlanket();
                dataTable.highlightNewRows(function () {
                    return _.contains(params.n, $(this).data("username"));
                });
            },
            extraParams: function () {
                var $userFilters = $("#user-types", $actions);
                var $activeFilters = $("#user-active-filter", $actions);
                // Add the user types to the search request
                return {
                    userFilters: $userFilters.val() || [],
                    activeFilter: $activeFilters.val() || [],
                    n: params.n
                };
            }
        });


        // Initialise search box
        var filterText = dataTable.getQuery().filter;
        if (filterText) {
            dataTable.inputTextField.val(filterText).addClass("has-text");
        }
        dataTable.inputTextField.focus();

        function hideClearSearch(e) {
            //make sure the search is what was changed.
            if (e && !$(e.target).is(dataTable.inputTextField)) {
                return;
            }
            $('#users-list-search').find('.clear-search').toggleClass('hidden', !dataTable.inputTextField.val());
        }

        AJS.InlineDialog("#googleApps", "google-apps", function (content, trigger, showPopup) {
            getGoogleAppsData().done(function (agniDomain) {
                content.html(usermanagement.users.googleDomain());
                var link = $('#gapps-domain');
                var href = link.attr('href');
                link.attr('href', href + encodeURI(agniDomain));
                link.text(agniDomain);
            }).fail(function (xhr) {
                if (xhr.status === 404) {
                    // this is the response agni gives when its just not configured yet
                    content.html(usermanagement.users.googleSetup());
                } else {
                    // agni failed most likely due to confluence-standalone
                    content.html(usermanagement.users.googleUnavailable());
                }
            });
            showPopup();
        });

        var previousInput = dataTable.inputTextField.val();

        var delaySearch = _.debounce(function(){
            $('#users-list-search').submit();
        }, 200);


        return {
            events: {
                'submit #users-list-search': function (e) {
                    e.preventDefault();
                    var filterText = dataTable.inputTextField.val();
                    //setQuery so that we blow away all old filters and pagination
                    dataTable.setQuery('?filter=' + filterText);
                    dataTable.search();
                    dataTable.inputTextField.focus();
                },
                'click .clear-search': function () {
                    dataTable.inputTextField.val("").trigger('change').focus();
                    hideClearSearch();
                    //setQuery so that we blow away all old filters and pagination
                    dataTable.setQuery('');
                    dataTable.showBlanket();
                    dataTable.search();
                    dataTable.inputTextField.focus();
                },
                'click .aui-nav-pagination': function (e) {
                    dataTable.paginationEvent(e);
                },
                // cut and keyup event for IE9
                'input,keyup,cut #list-search-text': function () {
                    var searchValue = $.trim(this.value);

                    // Make sure the searched text is actually different.
                    if (searchValue !== previousInput) {
                        previousInput = searchValue;

                        var hasInput = !!searchValue;
                        dataTable.inputTextField.toggleClass("has-text", hasInput);
                        dataTable.toggleBlanket(true);
                        delaySearch();
                    }
                },
                'click .activationButton': function (event) {
                    var button = $(event.target);
                    var username = button.data('username');
                    if (button.data('active')) {
                        //the user is currently active, so deactivate
                        deactivateUser(username, function(){dataTable.search();});
                    } else {
                        //the user is currently not-active, so activate
                        activateUser(username, function(){dataTable.search();});
                    }
                }
        }};
    };

    userRoutes['delete'] = function (params) {
        var username = params.username;
        helpers.updateContent(usermanagement.users.deleteUser({
            username: username
        }));
        $.getJSON(AJS.contextPath() + '/rest/um/1/validation/user/predelete', {
            username: username
        }).done(function (data) {
            $('#user-delete-verifying').replaceWith(usermanagement.users.deleteForm({
                username: username,
                errors: data.errors,
                applicationReferences: data.references,
                hasErrors: data.hasErrors
            }));
            if (!data.hasErrors) {
                // Hook up the actual delete call to the "Delete" button of the form
                var form = new root.UMForm("#user-delete", "delete", {
                    insertErrorsAutomagically: false
                });

                form.on("done" ,function () {
                    new root.UMFlashMessage("success", {
                        title: AJS.I18n.getText("usermanagement.users.delete.success", username)
                    });
                    adminApp.app.navigate('list', { type: 'users' });
                }).on("fail", function () {
                    // we may wish to check (jqXhr.status === 409) here and do something else.
                    adminApp.app.trigger("delete", { type: 'users', username: username });
                });
            }
        }).fail(function (xhr) {
            $('#user-delete-verifying').replaceWith(usermanagement.users.deleteForm({
                username: username,
                hasErrors: true,
                errors: JSON.parse(xhr.responseText).errors
            }));
        });
        return {
            focusedTask: true
        };
    };

    userRoutes.edit = function (params) {
        getUserDetails(params.username).done(function (data) {
            var warnings = [];

            if (data.isSelf) {
                warnings.push(AJS.I18n.getText('usermanagement.warning.cannot.rename.self'));
            }
            if (data.attributes["agni.gapps.user.state"] === "activated") {
                warnings.push(AJS.I18n.getText("usermanagement.warning.rename.googleapps", data.display_name));
            }

            var dialog = new root.UMModal({
                template: usermanagement.users.edit(_.extend({
                    warnings: warnings
                }, data)),
                title:  AJS.I18n.getText('usermanagement.users.edit.title'),
                submitButton: AJS.I18n.getText('usermanagement.generic.save')
            });

            $("#display-name").focus();

            new root.UMForm("#user-edit-add", "PUT", {
                dataFormatter: formatData
            }).on("done", function (response) {
                if (response && params.username !== response.name) {
                    new root.UMFlashMessage("success", {
                        title: AJS.I18n.getText("usermanagement.users.success.rename", params.username, response.name)
                    });
                    adminApp.app.navigate('detail', { type: 'users', username: response.name });
                    dialog.remove();
                } else {
                    var name = this.find("[name='name']").val();
                    new root.UMFlashMessage("success", {
                        title: AJS.I18n.getText("usermanagement.users.success.edited", name)
                    });
                    // User details have been updated.
                    getUserDetails.reset(name);
                    getApplicationWithSeats.reset();
                    dialog.remove();
                    adminApp.app.trigger('detail', { type: 'users', username: name });
                }
            });
        });

        return {
            partial: true
        };
    };

    userRoutes.detail = function (params) {
        var userName = params.username;
        var table = null;

        //Calculate if there are any added groups, if so we add them as the extra param 'n'
        //"Why n?" I hear you ask. Because thats what Alex coded and its stuck. I assume it means 'new'. Sorry.
        var potentialAddedGroups = params.potentialAddedGroups;
        var groupParam = {}; //If we don't have a blank to give it, it gets sad.
        if (potentialAddedGroups) {
            groupParam = { "n": potentialAddedGroups }
        }

        $.when(helpers.ajax.getLicenseUsage(), getUserDetails(userName)).done(function (licenseUsage, data) {
            var apps = licenseUsage.products;
            var appTypes = _.pluck(apps, "description");
            data = $.extend({}, data, {
                //TODO: perhaps add a title/tooltip here
                applications: formatApplications({
                    applications: apps,
                    autoUpgradeMode: licenseUsage.autoUpgradeMode,
                    accessLevels: data.accessLevels,
                    disableAll: (data.unmodifiableMemberships || data.isSelf),
                    hideLicenceDetails: true
                }),
                dissociateDisabled: !data.aidAccount,
                isActive: data.active,
                hasJira: _.contains(appTypes, "JIRA")
            });

            helpers.updateContent(usermanagement.users.view(data));
            var $tableContainer = $('#user-memberships');
            table = new root.UMDataTable('groups', {
                container: $tableContainer,
                searchTriggerContainer: $tableContainer,
                parse: function (data) { return data.groups; },
                url: AJS.contextPath() + '/rest/um/1/user/group/direct',
                noResultsMessage: AJS.I18n.getText('usermanagement.users.groups.no.groups'),
                rowTemplate: usermanagement.groups.row_member_group,
                searchFilter: root.helpers.groups.groupSearchFilter,
                extraParams: groupParam,
                loadedCallback: function () {
                    helpers.tooltips();
                    //Find the table
                    table.highlightNewRows(function() { return $.inArray($(this).data("group"), potentialAddedGroups) > -1; });
                }
            });

            manipulation.groups.setupUserRemovalFromGroup({
                table: table.getTableElement(),
                userName: userName,
                completed: function(groupName, userName) {
                    getUserDetails.reset(userName);
                    getApplicationWithSeats.reset();
                    adminApp.app.trigger("detail", { type: "users", username: userName });
                }
            });

            $('.view-user-applications input.checkbox').on('change', function () {
                var $this = $(this);
                var $form = $('.view-user-applications');

                var method;
                var options = {};
                var successMessage;
                var errorMessage;

                var applicationName = AJS.I18n.getText('usermanagement.apps.selected.application'); // theoretically not needed, as $this.val() came from data.applications
                $.each(data.applications, function(i, application) {
                    if (application.id === $this.val()) {
                        applicationName = application.applicationName;
                    }
                });

                if ($this.is(':checked')) {
                    method = 'POST';
                    options.dataFormatter = function () {
                        return {
                            applicationLinks: [ $this.val() ],
                            users: [ userName ]
                        };
                    };
                    successMessage = AJS.I18n.getText('usermanagement.apps.user.granted.access.to.product', userName, applicationName);
                    errorMessage = AJS.I18n.getText('usermanagement.apps.user.granted.access.to.product.error', userName, applicationName);
                } else {
                    method = 'DELETE';
                    $form.attr('action', $form.attr('action') + '&appLinkId=' + $this.val());
                    successMessage = AJS.I18n.getText('usermanagement.apps.user.revoked.access.to.product', userName, applicationName);
                    errorMessage = AJS.I18n.getText('usermanagement.apps.user.revoked.access.to.product.error', userName, applicationName);
                }

                $this.closest('.group').find('input.checkbox').attr('disabled', 'disabled');

                new root.UMForm($form, method, options)
                    .on('done', function(data) {
                        if (!data || (data.completed[$this.val()] !== undefined && ~data.completed[$this.val()].successes.indexOf(userName))) {
                            getUserDetails.reset(userName);
                            getApplicationWithSeats.reset();
                            userUpdated.call(this, successMessage);
                        } else {
                            if (data && data.licenseExceeded[$this.val()] !== undefined) {
                                var exceeded = data.licenseExceeded[$this.val()];
                                errorMessage = AJS.I18n.getText('usermanagement.apps.license.exceeded.error', applicationName, exceeded.needed, exceeded.available);
                            } else if (data && data.aborted[$this.val()] !== undefined) {
                                errorMessage = data.aborted[$this.val()];
                            }
                            getUserDetails.reset(userName);
                            getApplicationWithSeats.reset();
                            new root.UMFlashMessage("error", {
                                title: errorMessage
                            });

                            adminApp.app.trigger('detail', { type: 'users', username: userName });
                        }
                    });

                $form.submit();
            });

            $('#add-group-button').click(function(event) {
                event.preventDefault();
                var dialog = new root.UMModal({
                    height: 200,
                    template: usermanagement.users.addGroup({
                        name: userName
                    }),
                    title:  AJS.I18n.getText('usermanagement.users.groups.add.title'),
                    submitButton: AJS.I18n.getText('usermanagement.users.groups.add')
                });

                var $parentGroup = $("#parentGroup");

                var groupPicker = helpers.groups.setupGroupPicker({
                    $element: $parentGroup,
                    multiple: true,
                    autoFocus: true
                });

                var UMFormOptions = {
                    dataFormatter: function(data) {
                        data.groups = [];
                        $.each(groupPicker.getGroups(), function(index, group){
                            data.groups.push({'name': group.id});
                        });
                        return data;
                    }
                };

                new root.UMForm('#user-add-group', 'POST', UMFormOptions)
                    .on('done', function(data) {
                        potentialAddedGroups = $.map(data.groups, function(group) { return group.name; });

                        getUserDetails.reset(userName);
                        getApplicationWithSeats.reset();
                        dialog.remove();

                        //Now we trigger a mini-refresh to update licence counts, get flash messages etc
                        adminApp.app.trigger("detail", { type: "users", username: userName, potentialAddedGroups: potentialAddedGroups });
                    });

                helpers.select2.resizeModalBasedOnHeight($parentGroup, dialog);
            });
        }).fail(function (xhr) {
            helpers.updateContent(AJS.messages.error({
                body: _.escape(JSON.parse(xhr.responseText).errors[0].message),
                closeable: false
            }));
        });

        function userUpdated(message) {
            new root.UMFlashMessage("success", {
                title: message
            });
            adminApp.app.trigger('detail', { type: 'users', username: userName });
        }

        return {
            events: {
                'click #edit-user-button': function (e) {
                    e.preventDefault();
                    adminApp.app.trigger("edit", { type: "users", username: userName });
                },
                'click #dissociate-link': function (e) {
                    if ($(e.target).attr('aria-disabled')) {
                        //The link is disabled, but the css doesn't work in IE. Quit here.
                        return false;
                    }
                    e.preventDefault();
                    var dialog = new root.UMModal({
                        id: "dissociate-AID-confirmation-dialog",
                        template:  AJS.I18n.getText('usermanagement.users.AID.dissociate.confirmation.desc'),
                        title:  AJS.I18n.getText('usermanagement.users.AID.dissociate.confirmation.title'),
                        submitButton: AJS.I18n.getText('usermanagement.users.AID.dissociate.confirmation.button'),
                        onSubmit: function () {
                            $.ajax({
                                type: 'DELETE',
                                url: AJS.contextPath() + '/rest/um/1/user/AID?username=' + encodeURIComponent(userName)
                            }).done(function () {
                                new root.UMFlashMessage("success", {
                                    title: AJS.I18n.getText('usermanagement.users.AID.dissociate.success')
                                });
                                getUserDetails.reset(userName);
                            }).fail(function () {
                                new root.UMFlashMessage("error", {
                                    title: AJS.I18n.getText('usermanagement.users.AID.dissociate.error')
                                });
                            }).always(function () {
                                dialog.remove();
                                adminApp.app.trigger('detail', { type: 'users', username: userName });
                            });
                        }
                    });
                },
                'click #change-password-button': function(e) {
                    e.preventDefault();
                    getUserDetails(userName).done(function (data) {
                        var dialog = new root.UMModal({
                            height: 260,
                            template: usermanagement.users.change_password(data),
                            title:  AJS.I18n.getText('usermanagement.users.change.password.title'),
                            submitButton: AJS.I18n.getText('usermanagement.users.change.password.button')
                        });

                        var changePasswordForm = new root.UMForm("#user-change-password", "PUT").on("done", function () {
                            dialog.remove();
                            userUpdated.call(this, AJS.I18n.getText("usermanagement.users.success.password.changed", userName));
                        });

                        root.password.PasswordMeter.addToForm({
                            context: '#user-change-password',
                            inputSelector: '#value',
                            addValidationTo: changePasswordForm
                        });
                        dialog.updateHeight();
                    });
                },
                'click .aui-nav-pagination': function (e) {
                    table.paginationEvent(e);
                },
                'click #delete-user-button' : function () {
                    adminApp.app.navigate('delete', { type: 'users', username: userName });
                },
                'click #change-user-active-button' : function (e) {
                    var button = $(e.target);

                    var newHeaderHtml = usermanagement.util.userDisplayName({
                        name: userName,
                        display_name: $('#user-name-title').text(),
                        lozenge: button.data('user-state') ? {title: AJS.I18n.getText('usermanagement.users.lozenge.description.deactive'), name: AJS.I18n.getText('usermanagement.users.lozenge.text.deactive')} : '',
                        isActive: !button.data('user-state')
                    });

                    getUserDetails.reset(userName); //kill the cache so it gets the lozenge next time

                    if (button.data('user-state')) {
                        deactivateUser(userName,
                            function () {
                                $('#change-user-active-button').text(AJS.I18n.getText('usermanagement.users.button.activate')).data("user-state", false);
                                $('#user-header').html(newHeaderHtml);

                                $("#page-data").find('.aui-message').remove();
                                AJS.messages.success("#page-data", {
                                    title: AJS.I18n.getText("usermanagement.users.deactivate.success.message", userName),
                                    insert: "prepend"
                                });
                            });
                    } else {
                        activateUser(userName,
                            function () {
                                $('#change-user-active-button').text(AJS.I18n.getText('usermanagement.users.button.deactivate')).data('user-state', true);
                                $('#user-header').html(newHeaderHtml);

                                $("#page-data").find('.aui-message').remove();
                                AJS.messages.success("#page-data", {
                                    title: AJS.I18n.getText("usermanagement.users.activate.success.message", userName),
                                    insert: "prepend"
                                });
                            });
                    }
                }
            }
        }
    };

    userRoutes.add = function () {
        helpers.updateContent(usermanagement.users.addPrefetch());
        helpers.ajax.getLicenseUsage().done(function (licenceUsage) {
            var apps = licenceUsage.products;
            apps = formatApplications({
                applications: apps,
                autoUpgradeMode: licenceUsage.autoUpgradeMode,
                hideLicenceDetails: licenceUsage.autoUpgradeMode && licenceUsage.autoUpgradeMode.enabled
            });
            helpers.updateContent(usermanagement.users.edit({
                applications: apps,
                action: AJS.contextPath() + "/rest/um/1/user",
                warnings: []
            }));

            $("[autofocus]").focus();

            $("#page-data").find("#create-another")
                .prop('checked', sessionStorage[CREATE_ANOTHER_STORAGE_KEY] === "true")
                .change(function () {
                    sessionStorage[CREATE_ANOTHER_STORAGE_KEY] = this.checked;
                });

            var addUserForm = new root.UMForm("#user-edit-add", "POST", {
                insertErrorsAutomagically: true,
                dataFormatter: formatData,
                presubmitValidator: function (validation) {
                    var sendNotification = $("#send-notification").is(':checked');
                    var password = $("#password");
                    if (!sendNotification && password.val() === "") {
                        validation.addFieldError("password", AJS.I18n.getText('usermanagement.users.password.empty'));
                    }
                }
            }).on("done", function (data) {
                    userRoutes.messages.displayUserSuccessfullyAddedMessage({
                        isAutoUpgradeModeEnabled: licenceUsage.autoUpgradeMode.enabled,
                        oldLicenseUsages: licenceUsage.products,
                        emailSent: $("#send-notification").is(':checked'),
                        user: data
                    }).then(function () {
                        getApplicationWithSeats.reset(); // More than likely seat counts have changed after creating user

                        if (sessionStorage[CREATE_ANOTHER_STORAGE_KEY] === "true") {
                            adminApp.app.trigger('add', { type: 'users' });
                        } else {
                            adminApp.app.navigate('detail', { type: 'users', username: data.name });
                        }
                    });
                });

            root.password.PasswordMeter.addToForm({
                context: '#user-edit-add',
                inputSelector: '#password',
                addValidationTo: addUserForm,
                allowEmpty: true // empty is sometimes valid here--use a custom validator
            });
        });

        return {
            events: {
                'change #send-notification': function () {
                    $('.passwords').slideToggle('fast');
                    $('#password').val('');
                }
            },
            focusedTask: true
        }
    };

    userRoutes.invite = function () {
        helpers.updateContent(usermanagement.users.createPrefetch());
        helpers.ajax.getLicenseUsage().done(function (licenceUsage) {
            helpers.updateContent(usermanagement.users.create({
                expiryDays: +localStorage[INVITE_EXPIRY_STORAGE_KEY] || DEFAULT_INVITE_EXPIRY,
                applications: formatApplications({
                    applications: licenceUsage.products,
                    autoUpgradeMode: licenceUsage.autoUpgradeMode,
                    hideLicenceDetails: licenceUsage.autoUpgradeMode && licenceUsage.autoUpgradeMode.enabled
                }),
                host: location.origin,
                sender: $("meta[name='remote-user-fullname']").attr("content")
            }));

            var emailPicker = helpers.users.setupMultipleEmailPicker($("#emailAddresses"));

            var form = new root.UMForm('#user-create', 'POST', {
                dataFormatter: function (data) {
                    return {
                        applications: data.applications || [],
                        emailAddresses: emailPicker.getEmails(),
                        expiryDays: +data.expiryDays,
                        text: data.text
                    };
                }
            }).on('done', function (newUsers) {
                    userRoutes.messages.displayUserSuccessfullyAddedMessage({
                        isAutoUpgradeModeEnabled: licenceUsage.autoUpgradeMode.enabled,
                        oldLicenseUsages: licenceUsage.products,
                        emailSent: newUsers.length ? true : false,
                        users: newUsers
                    }).then(function () {
                        getApplicationWithSeats.reset(); // More than likely seat counts have changed after creating user
                        adminApp.app.navigate('list', { type: 'users', n: newUsers });
                    });
                }).on('always', function () {
                    localStorage[INVITE_EXPIRY_STORAGE_KEY] = form._formData().fields.expiryDays;
                });
        });

        return {
            focusedTask: true
        };
    };

    userRoutes.resetpassword = function (params) {
        $.getJSON(AJS.contextPath() + '/rest/um/1/resetpassword', {
            username: params.username,
            directoryId: params.directoryId,
            token: params.token
        }).done(function (data) {
            if (data && data.invalidToken) {
                helpers.updateContent(usermanagement.users.resetPasswordError());
                return;
            }
            helpers.updateContent(usermanagement.users.resetPassword({
                name: params.username,
                display_name: data.displayName,
                email: data.email,
                directoryId: params.directoryId,
                token: params.token,
                policyScore: {
                    name: AJS.I18n.getText('usermanagement.passwordpolicy.names.' + data.policyScore.name).toLowerCase(),
                    ranking: data.policyScore.ranking
                }
            }), {
                hideUserControls: true
            });

            var resetPasswordForm = new root.UMForm("#user-reset-password", "POST").on("done", function() {
                // Re-route to root of application for Indra to take over log in etc
                window.location = '/';
            });

            root.password.PasswordMeter.addToForm({
                context: '#user-reset-password',
                inputSelector: '#password',
                addValidationTo: resetPasswordForm,
                policyScore: data.policyScore.ranking
            });
        });

        return {
            focusedTask: true,
            anonymous: true
        }
    };

    userRoutes.changepassword = function (params) {
        var returnUrlUntrimmed = params.returnUrl || '';
        $.getJSON(AJS.contextPath() + '/rest/um/1/changepassword').done(function (data) {
            if (data.usernameValid) {
                var returnUrl = returnUrlUntrimmed.trim();
                if (returnUrl[0] !== "/" || returnUrl[1] === "/") {
                    returnUrl = "/"; //Potentially malicious, default to root
                }

                helpers.updateContent(usermanagement.users.changePassword({
                    name: data.username,
                    display_name: data.display,
                    email: data.email,
                    returnUrl: returnUrl,
                    policyScore: {
                        name: AJS.I18n.getText('usermanagement.passwordpolicy.names.' + data.policyScore.name).toLowerCase(),
                        ranking: data.policyScore.ranking
                    }
                }), {
                    hideUserControls: true
                });

                var changePasswordForm = new root.UMForm("#user-change-password", "POST").on("done", function () {
                    sessionStorage.passwordchanged = true;
                    window.location = returnUrl;
                });

                root.password.PasswordMeter.addToForm({
                    context: '#user-change-password',
                    inputSelector: '#new-password',
                    addValidationTo: changePasswordForm,
                    policyScore: data.policyScore.ranking
                });
            } else {
                helpers.updateContent(usermanagement.users.changePasswordError({ error: AJS.I18n.getText('usermanagement.users.change.password.invalid.user', data.username)}), {
                    hideUserControls: true
                });
            }
        }).fail(function () {
            helpers.updateContent(usermanagement.users.changePasswordError({error: AJS.I18n.getText('usermanagement.users.change.password.no.logged.in.user')}), {
                hideUserControls: true
            });
        });

        return {
            focusedTask: true,
            anonymous: true
        }
    };

    userRoutes["sign-up"] = function (params) {
        if (params.token) {
            $.getJSON(AJS.contextPath() + '/rest/um/1/signup', {
                token: params.token
            }).done(function (data) {
                helpers.updateContent(usermanagement.users.signUpWithToken({
                    token: params.token,
                    email: data.invitation.emailAddress
                }));

                // AUI Form Soy stuff currently doesn't have anything
                // to show the ADG help icon. Let's insert it with JS
                // for now. The space is required, otherwise it renders
                // too close to the input element.
                var $helpIcon = $(aui.icons.icon({ icon: "help" }));
                $helpIcon.attr("title", AJS.I18n.getText("usermanagement.users.sign.up.email.help.text")).tooltip({gravity: 'w'});
                $("#email").after($helpIcon).after(" ");

                var signUpForm = new root.UMForm("#user-edit-add", "POST", {
                    dataFormatter: formatData
                }).on("done", function () {
                    var name = this.find("[name='name']").val();
                    new root.UMFlashMessage("success", {
                        title: AJS.I18n.getText("usermanagement.users.success.edited", name)
                    });
                    window.location = "/";
                });

                root.password.PasswordMeter.addToForm({
                    context: '#user-edit-add',
                    inputSelector: '#password',
                    addValidationTo: signUpForm,
                    policyScore: data.policyScore.ranking
                });
            }).fail(function (xhr) {
                helpers.updateContent(AJS.messages.error({
                    body: _.escape(JSON.parse(xhr.responseText).errors[0].message),
                    closeable: false
                }));
            });
        } else {
            helpers.updateContent(usermanagement.users.signUp({
                email: params.email
            }));

            $("[autofocus]").focus();

            showRecaptcha("captcha-container");

            new root.UMForm("#user-signup", "POST").on("done", function () {
                var email = $("#email").val();
                helpers.updateContent(usermanagement.users.signUpEmailSent({
                    email: email
                }));

                $("#resend-email").click(function (e) {
                    e.preventDefault();
                    adminApp.app.trigger('sign-up', { type: 'users', email: email });
                });
            }).on("fail", Recaptcha.reload);
        }

        return {
            focusedTask: true,
            anonymous: true,
            events: {
                "click #captcha-reload": function (e) {
                    e.preventDefault();
                    Recaptcha.reload();
                },
                "click #captcha-switch-audio": function (e) {
                    e.preventDefault();
                    Recaptcha.switch_type("audio");
                },
                "click #captcha-switch-image": function (e) {
                    e.preventDefault();
                    Recaptcha.switch_type("image")
                }
            }
        };
    };

    var getUserDetails = helpers.memoize(function(username) {
        var deferred = new $.Deferred();

        $.getJSON(AJS.contextPath() + '/rest/um/1/user', {
            username: username,
            expand: 'attributes'
        }).done(function (data) {
            deferred.resolve(helpers.users.sanitiseAndMapUserData(data));
        }).fail(function (xhr) {
            deferred.reject(xhr);
        });

        return deferred.promise();
    });

    var getGoogleAppsData = function () {
        var deferred = new $.Deferred();

        // Using $.get() here since even though the Content-Type is application/json,
        // the response is not valid JSON and cannot be parsed as such.
        $.get(AJS.contextPath() + '/rest/um/1/agni').done(function (url) {
            $.get(url).done(function (data) {
                deferred.resolve(data);
            }).fail(function (xhr) {
                deferred.reject(xhr);
            });
        }).fail(function (xhr) {
            deferred.reject(xhr);
        });

        return deferred.promise();
    };

    var getApplicationWithSeats = helpers.memoize(helpers.ajax.getApplicationWithSeats);

    function formatData(data) {
        var formatted = {};
        $.each(data, function (key, value) {
            if (key == 'password') {
                if ($.trim(value)) {
                    formatted[key] = { value: value };
                }
            } else if (!~ignoredFields.indexOf(key)) {
                formatted[key] = value;
            }
        });
        return formatted;
    }

    /**
     * @param options.applications
     * @param options.autoUpgradeMode
     * @param [options.accessLevels]
     * @param [options.disableAll]
     * @param [options.hideLicenceDetails]
     */
    function formatApplications(options) {
        return $.map(helpers.applicationDataMappers.formatApplications(options), function (app) {
            // keep the actual application name separate so that we can reference it during modification
            app.applicationName = app.name;

            // AUI Checkbox uses the 'name' attribute to name checkboxes.
            // We want the checkboxes to be named 'applications' instead of the actual app name
            app.name = "applications";

            return app;
        });
    }

    userRoutes.sanitiseUserData = function (data) {
        return $.map(data, helpers.users.sanitiseAndMapUserData);
    };

    function activateUser (username, successFunction) {
        $.ajax({
            type: 'POST',
            url: AJS.contextPath() + '/rest/um/1/user/activate?username=' + encodeURIComponent(username)
        })
            .done(successFunction)
            .fail(function () {
            new root.UMFlashMessage("error", {
                title: AJS.I18n.getText("usermanagement.users.activate.error.message", username)
            });
        });
    }

    function deactivateUser (username, successFunction) {
        $.ajax({
            type: 'POST',
            url: AJS.contextPath() + '/rest/um/1/user/deactivate?username=' + encodeURIComponent(username)
        })
            .done(successFunction)
            .fail(function () {
            new root.UMFlashMessage("error", {
                title: AJS.I18n.getText("usermanagement.users.deactivate.error.message", username)
            });
        });
    }

}(AJS.$, window.UserManagement = window.UserManagement || {}, window.adminApp));

