(function ($, root) {

    root.routes = root.routes || {};

    root.routes.signup = {
        list: function () {

            $.when($.getJSON(AJS.contextPath() + '/rest/um/1/signupoptions')).done(function (signupoptionsarguments) {
                UserManagement.models.DefaultApps.fetch().done(function (defaultapps) {
                    var signupoptions = signupoptionsarguments[0];

                    root.helpers.updateContent(usermanagement.signup.options($.extend({
                        defaultapps: defaultapps
                    }, signupoptions)));

                    new root.UMForm('#signup-domains-form', 'POST', {
                        dataFormatter: function (data) {
                            data.signupEnabled = !!data.signupEnabled;
                            data.notifyAdmin = !!data.notifyAdmin;
                            if (data.signupMode !== "restricted") {
                                delete data.domains;
                            } else {
                                data.domains = data.domains.split(",");
                            }
                            delete data.signupMode;
                            return data;
                        }
                    }).on('done', function () {
                            new root.UMFlashMessage("success", {
                                title: AJS.I18n.getText('usermanagement.signup.updated'),
                                fadeout: true
                            });
                            adminApp.app.trigger('list',  { type: 'signup' });
                        });

                    root.helpers.users.setupMultipleEmailPicker($("#domains-signup"), {
                        width: 500
                    });
                });
            });

            return {
                events: {
                    "change #signupEnabled": function () {
                        var isPublicSignUp = $("#signupMode-public").prop("checked");
                        $("#signupMode-public, #signupMode-restricted").prop("disabled", !this.checked);
                        $("#domains-signup").prop("disabled", !this.checked || isPublicSignUp).trigger("propertychange");
                    },
                    "change [name='signupMode']": function () {
                        $("#domains-signup").prop("disabled", this.value !== "restricted").trigger("propertychange");
                    }
                }
            };
        }
    };

}(AJS.$, window.UserManagement = window.UserManagement || {}, window.adminApp));