(function ($, root, adminApp) {
    root.routes = root.routes || {};
    var helpers = root.helpers;
    var manipulation = root.manipulation;
    var groupRoutes = root.routes.groups = {};

    groupRoutes.list = function (params) {

        helpers.updateContent(usermanagement.groups.actions());

        var dataTable = new root.UMDataTable(params.type, {
            searchTriggerContainer: "#groups-list-search",
            searchFilter: helpers.groups.groupSearchFilter,
            loadedCallback: function () {
                helpers.tooltips();
                dataTable.hideBlanket();
            }
        });
        var filter = dataTable.getQuery()['filter'];

        if (filter) {
            dataTable.inputTextField.val(filter).addClass("has-text");
        }
        dataTable.inputTextField.focus();

        var previousInput = dataTable.inputTextField.val();

        var delaySearch = _.debounce(function(){
            $('#groups-list-search').submit();
        }, 200);


        return {
            events: {
                'submit #groups-list-search': function (e) {
                    e.preventDefault();
                    var filter = dataTable.inputTextField.val();
                    //setQuery so that we blow away all old filters and pagination
                    dataTable.setQuery('?filter=' + filter);
                    dataTable.search();
                },
                'click .clear-search': function () {
                    dataTable.inputTextField.val("").trigger('change').focus();
                    //setQuery so that we blow away all old filters and pagination
                    dataTable.setQuery('');
                    dataTable.showBlanket();
                    dataTable.search();
                    dataTable.inputTextField.focus();
                },
                'click .aui-nav-pagination': function (e) {
                    dataTable.paginationEvent(e);
                },
                // cut and keyup event for IE9
                'input,keyup,cut #list-search-text': function (e) {
                    var searchValue = $.trim(this.value);
                    // Make sure the searched text is actually different.
                    if (searchValue !== previousInput) {
                        previousInput = searchValue;

                        var hasInput = !!searchValue;
                        dataTable.inputTextField.toggleClass("has-text", hasInput);
                        dataTable.toggleBlanket(true);
                        delaySearch();
                    }
                }
            }
        };
    };

    groupRoutes.add = function () {
        helpers.updateContent(usermanagement.groups.edit({}));
        buildForm(false).on('done', function (data) {
            adminApp.app.navigate('detail', { type: 'groups', groupname: data.name });
        });
        $("#name").focus();
        return {focusedTask: true};
    };

    groupRoutes["delete"] = function (params) {
        var groupname = params.groupname;
        var returnToList = params.returnToList === "true";
        helpers.updateContent(usermanagement.groups.deleteGroup({
            groupname: groupname
        }));
        $.getJSON(AJS.contextPath() + '/rest/um/1/validation/group/predelete', {
            groupname: groupname
        }).done(function (data) {
            $('#group-delete-verifying').replaceWith(usermanagement.groups.deleteForm({
                groupname: groupname,
                errors: data.errors,
                applicationReferences: data.references,
                hasErrors: data.hasErrors,
                returnToList: returnToList
            }));
            if (!data.hasErrors) {
                // Hook up the actual delete call to the "Delete" button of the form
                var form = new root.UMForm("#group-delete", "delete", {
                    insertErrorsAutomagically: false
                });

                form.on("done", function () {
                    new root.UMFlashMessage("success", {
                        title: AJS.I18n.getText("usermanagement.group.delete.success", groupname)
                    });
                    adminApp.app.navigate('list', { type: 'groups' });
                }).on("fail", function () {
                    // we may wish to check (jqXhr.status == 409) here and do something else.
                    adminApp.app.trigger("delete", { type: 'groups', groupname: groupname });
                });
            }
        }).fail(function (xhr) {
            $('#group-delete-verifying').replaceWith(usermanagement.groups.deleteForm({
                groupname: groupname,
                hasErrors: true,
                errors: JSON.parse(xhr.responseText).errors
            }));
        });

        return {
            focusedTask: true
        };
    };

    groupRoutes.edit = function (params) {
        getGroupDetails(params.groupname).done(function (data) {
            var dialog = new root.UMModal({
                template: usermanagement.groups.edit(data),
                title:  AJS.I18n.getText('usermanagement.group.edit.title'),
                submitButton: AJS.I18n.getText('usermanagement.generic.save')
            });
            buildForm(true).on('done', function (data) {
                dialog.remove();
                adminApp.app.trigger('detail', { type: 'groups', groupname: data.name });
            });
        });
        return {
            partial: true
        };
    };

    groupRoutes.detail = function me(params, container) {
        var groupName = params.groupname;
        var table;
        var potentialNewUsersAdded = null;

        $.when(getGroupDetails(groupName), requestMembershipCount(groupName)).done(function (rawData, rawCountData) {
            var data = rawData[0];
            var countData = rawCountData[0];

            var localContainer = container || "#group-memberships";

            helpers.updateContent(usermanagement.groups.view(data));
            table = new root.UMDataTable("users", {
                container: localContainer,
                url: AJS.contextPath() + '/rest/um/1/group/user/direct',
                noResultsMessage: AJS.I18n.getText('usermanagement.group.members.no.members'),
                parse: root.routes.users.sanitiseUserData,
                rowTemplate: usermanagement.users.row_group_member,
                tableTemplateOptions: {hideDeactivate: true},
                loadedCallback: function () {
                    helpers.tooltips();
                    table.highlightNewRows(function() { return $.inArray($(this).data("username"), potentialNewUsersAdded) > -1; });
                    potentialNewUsersAdded = null;
                }
            });

            updateMembershipText(countData);

            manipulation.groups.setupUserRemovalFromGroup({
                table: table.getTableElement(),
                groupName: groupName,
                completed: function(groupName) {
                    table.search({
                        pushState: false
                    });

                    adminApp.app.trigger("detail", { type: "groups", groupname: groupName });
                }
            });

            $("#add-group-member").click(function(event) {
                event.preventDefault();
                var dialog = new root.UMModal({
                    template: usermanagement.groups.add_user_to_group({ name: groupName }),
                    title:  AJS.I18n.getText('usermanagement.group.add.user.title'),
                    submitButton: AJS.I18n.getText('usermanagement.group.users.add')
                });

                var $input = dialog.getCurrentPanel().body.find("#users");

                var userPicker = helpers.users.setupMultipleUserPicker({
                    element: $input,
                    userFilters: ["users"],
                    autoFocus: true
                });

                helpers.select2.resizeModalBasedOnHeight($input, dialog);

                var UMFormOptions = {
                    dataFormatter: function(data) {
                        data.users = [];
                        $.each(userPicker.getUsers(), function(index, user){
                            data.users.push({'name': user.id});
                        });
                        return data;
                    }
                };

                new root.UMForm('#add-user-to-group', 'POST', UMFormOptions)
                    .on('done', function(data) {
                        potentialNewUsersAdded = $.map(data.users, function(user) { return user.name });
                        table.setQueryParam("n", potentialNewUsersAdded);
                        table.search({
                            pushState: false
                        });
                        dialog.remove();

                        requestMembershipCount(groupName).done(updateMembershipText);
                    });

            });

        }).fail(function (xhr) {
            helpers.updateContent(AJS.messages.error({
                body: _.escape(JSON.parse(xhr.responseText).errors[0].message),
                closeable: false
            }));
        });

        return {
            events: {
                'click #edit-group-button': function (e) {
                    e.preventDefault();
                    adminApp.app.trigger("edit", { type: "groups", groupname: groupName });
                },
                'click .aui-nav-pagination': function (e) {
                    table.paginationEvent(e);
                }
            }
        };
    };

    function buildForm(isUpdate) {
        var addForm = new root.UMForm("#group-edit-add", isUpdate ? "PUT" : "POST");

        return addForm.on("done",function (data) {
            new root.UMFlashMessage("success", {
                title: isUpdate ? AJS.I18n.getText("usermanagement.group.success.edited", data.name)
                                : AJS.I18n.getText("usermanagement.group.success.created", data.name)
            });

            // Group details have been updated.
            getGroupDetails.reset(data.name);
        });
    }

    var getGroupDetails = helpers.memoize(function(groupName) {
        return $.getJSON(AJS.contextPath() + '/rest/um/1/group', {
            groupname: groupName
        });
    });

    var requestMembershipCount = function(groupName) {
        return $.getJSON(AJS.contextPath() + '/rest/um/1/group/count', {
            groupname: groupName
        });
    };

    var updateMembershipText = function(data) {
        var boundedMemberCount = data.memberCount;
        var displayText;
        if(boundedMemberCount.exact) {
            displayText = String(boundedMemberCount.count);
        } else {
            var countBarrier = boundedMemberCount.count - 1;
            displayText = countBarrier + "+";
        }

        $("#group-header").find(".membership-count").text(displayText).removeClass('hidden');
    };

}(AJS.$, window.UserManagement = window.UserManagement || {}, window.adminApp));
