(function ($, root) {
    root.routes = root.routes || {};
    var accessConfigRoutes = root.routes.accessconfig = {};
    var helpers = root.helpers;

    accessConfigRoutes.list = function () {
        helpers.updateContent();
        
        $.when($.getJSON(AJS.contextPath() + '/rest/um/1/accessconfig')).done(function (config) {
            helpers.updateContent(usermanagement.accessconfig.table(config));
            tooltips();
            initHelpDialogs();
            var $accessConfig = $('.access-config');
            $accessConfig.on('click', 'input[type="checkbox"]', function() {
                var $this = $(this);

                var $spinner = $(usermanagement.loading());
                $this.after($spinner);
                $this.hide();
                
                var $product = $this.closest('tbody');
                var $tr = $this.closest('tr');

                $.ajax({
                    url: AJS.contextPath() + "/rest/um/1/accessconfig/group" +
                            "?hostId=" + encodeURIComponent($product.data('host-id')) +
                            "&productId=" + encodeURIComponent($product.data('product-id')),
                    dataType: 'json',
                    type: "put",
                    contentType: 'application/json',
                    data: JSON.stringify(toGroup($tr))
                }).fail(function (jqXhr) {
                    $spinner.remove();
                    $this.show();
                    
                    try {
                        new root.UMFlashMessage("error", {
                            title: JSON.parse(jqXhr.responseText).errors[0].message
                        });
                    } catch (e) {
                        new root.UMFlashMessage("error", {
                            title: 'Massive error'
                        });
                        AJS.log(e);
                    }
                }).done(function () {
                    $spinner.remove();
                    $this.show();

                    // if no checkboxes are checked, remove the row
                    if (!$tr.find('input:checked').length) {
                        $tr.addClass('deleteHighlight').fadeOut('fast', function() {
                            $(this).remove();
                        });
                    } else {
                        refreshRow($tr, false, false);
                        tooltips();
                    }
                });

            });

            $('.add-group').on('click', function() {
                var $this = $(this);
                var $product = $this.closest('tbody');
                var hostId = $product.data('host-id');
                var productId = $product.data('product-id');
                
                var dialog = new root.UMModal({
                    height: 200,
                    template: usermanagement.accessconfig.addGroup({
                        hostId: hostId,
                        productId: productId
                    }),
                    title: AJS.I18n.getText('usermanagement.accessconfig.groups.grant.title', $product.children('.product-header').text()),
                    submitButton: AJS.I18n.getText('usermanagement.accessconfig.groups.grant')
                });

                var $parentGroup = $("#parentGroup");

                var groupPicker = helpers.groups.setupGroupPicker({
                    $element: $parentGroup,
                    multiple: true,
                    autoFocus: true
                });

                var UMFormOptions = {
                    dataFormatter: function(data) {
                        data = [];
                        $.each(groupPicker.getGroups(), function(index, group){
                            data.push(group.id);
                        });
                        return data;
                    }
                };

                new root.UMForm('#access-add-group', 'POST', UMFormOptions)
                    .on('done', function(data) {
                        $.each(data, function(index, group) {
                            $(usermanagement.accessconfig.group({
                                productConfigurable: true,
                                productName: '',
                                group: group,
                                isNew: true
                            })).insertAfter($product.children('.product-header'));
                        });
                        tooltips();

                        dialog.remove();
                    });

                helpers.select2.resizeModalBasedOnHeight($parentGroup, dialog);
            });

            $accessConfig.on('click', '.make-default', function() {
                var $this = $(this);

                var $spinner = $(usermanagement.loading());
                $this.after($spinner);
                $this.hide();

                var $product = $this.closest('tbody');
                var hostId = $product.data('host-id');
                var productId = $product.data('product-id');

                var $tr = $this.closest('tr');
                var group = toGroup($tr);
                var admin = hasAccess(group.admin);
                
                $.ajax({
                    url: AJS.contextPath() + "/rest/um/1/accessconfig/makedefault?hostId=" + encodeURIComponent(hostId) + "&productId=" + encodeURIComponent(productId) + '&groupname=' + group.name + '&admin=' + admin,
                    dataType: 'json',
                    type: "post",
                    contentType: 'application/json'
                }).fail(function (jqXhr) {
                    $spinner.remove();
                    $this.show();

                    try {
                        new root.UMFlashMessage("error", {
                            title: JSON.parse(jqXhr.responseText).errors[0].message
                        });
                    } catch (e) {
                        new root.UMFlashMessage("error", {
                            title: 'Massive error'
                        });
                        AJS.log(e);
                    }
                }).done(function () {
                    $spinner.remove();
                    $this.remove();
                    
                    $product.find('.default-' + (admin ? 'admin' : 'use')).each(function() {
                        var $lozenge = $(this);
                        var $defaults = $lozenge.closest('.defaults-wrapper');
                        $lozenge.remove();
                        if (!$defaults.children().length) {
                            refreshRow($defaults.closest('tr'));
                        }
                    });

                    refreshRow($tr, {
                        defaultUse: !admin,
                        defaultAdmin: admin
                    });
                    tooltips();
                });
                
            });
        });

        var refreshRow = function($tr, overrides) {
            $tr.replaceWith($(usermanagement.accessconfig.group({
                productName: $tr.closest('tbody').data('product-name'),
                productConfigurable: true,
                group: $.extend(toGroup($tr), overrides),
                isNew: $tr.find('.aui-lozenge.new').length
            })));
        };
        
        var toGroup = function($tr) {
            return {
                name: $tr.data('group-name'),
                use: getAccessLevel($tr.children('.use').find('input')),
                admin: getAccessLevel($tr.children('.admin').find('input')),
                defaultUse: $tr.find('.default-use').length > 0,
                defaultAdmin: $tr.find('.default-admin').length > 0
            };
        };

        var getAccessLevel = function($input) {
            return $input.data('disabled') === 'true' ? 'DISABLED' : $input.is(':checked') ? 'DIRECT' : 'NONE';
        };
        
        var hasAccess = function(access) {
            return access === 'DIRECT';
        };

        var tooltips = function() {
            $('.aui-page-panel-content').find('.aui-lozenge[title]').tooltip();
        };

        var initHelpDialogs = function() {
            var $helpIcons = $('.access-config').find('.aui-icon.aui-iconfont-help');
            var dialog = new AJS.InlineDialog(
                $helpIcons,
                AJS.id('help-dialog'),
                function(content, trigger, showPopup) {
                    content.empty().append($(trigger).parent().find('.permission-column-desc').clone());
                    showPopup();
                    dialog.refresh();
                },
                {
                    offsetX: -100,
                    onHover: true,
                    gravity: 's'
                }
            );
        };

        return {
            
        };
    };

}(AJS.$, window.UserManagement = window.UserManagement || {}));
