(function(root, adminApp){
    //routing
    function routeHandler(routeData){
        var name = routeData.destination;
        var method = (root.routes[routeData.params.type] || {})[name];
        if (method) {
            return method(routeData.params);
        }
        return false;
    }
    var routes = [
        //list pages
        {name: "list", url: ':type', matchesWith: {type: /[^/]+/}, handler: routeHandler},
        //detail pages
        {name: "detail", url: ":type/view", handler: routeHandler},
        //edit pages
        {name: "edit", url: ":type/edit", handler: routeHandler},
        //push pages
        {name: "add", url: ":type/add", handler: routeHandler},
        //delete pages
        {name: "delete", url: ":type/delete", handler: routeHandler},
        //default application access, user sign-up, user invite, google apps setup, reset password
        {name: "set-defaults", url: ":type/set-defaults", handler: routeHandler},
        {name: "sign-up", url: ":type/sign-up", handler: routeHandler},
        {name: "invite", url: ":type/invite", handler: routeHandler},
        {name: "google", url: ":type/google", handler: routeHandler},
        {name: "resetpassword", url: ":type/resetpassword/:directoryId/:token", handler: routeHandler},
        {name: "changepassword", url: ":type/changepassword", handler: routeHandler}
    ];

    //sidebar
    var navigation = {
        title: AJS.I18n.getText('usermanagement.application.user.management'),
        links: [
            { name: AJS.I18n.getText('usermanagement.users.nav'), route: 'list', type: 'users'},
            { name: AJS.I18n.getText('usermanagement.groups.nav'), route: 'list', type: 'groups'},
            { name: AJS.I18n.getText('usermanagement.apps.nav'), route: 'list', type: 'apps'},
            { name: AJS.I18n.getText('usermanagement.signup.nav'), route: 'list', type: 'signup'}
        ]
    };
    if (adminApp.isFeatureEnabled("um.password.policy")) {
        navigation.links.push({ name: AJS.I18n.getText('usermanagement.passwordpolicy.nav'), route: 'list', type: 'passwordpolicy'});
    }
    if (UserManagement.feature.GoogleApps.isEnabled()) {
        navigation.links.push({ name: AJS.I18n.getText('usermanagement.googleapps.nav'), route: 'list', type: 'googleapps'});
    }

    //titles
    var titleMap = {
        "users": AJS.I18n.getText('usermanagement.application.user.management') + " - " + AJS.I18n.getText('usermanagement.users.nav'),
        "groups": AJS.I18n.getText('usermanagement.application.user.management') + " - " + AJS.I18n.getText('usermanagement.groups.nav'),
        "apps": AJS.I18n.getText('usermanagement.application.user.management') + " - " + AJS.I18n.getText('usermanagement.apps.nav'),
        "signup": AJS.I18n.getText('usermanagement.application.user.management') + " - " + AJS.I18n.getText('usermanagement.signup.nav'),
        "passwordpolicy": AJS.I18n.getText('usermanagement.application.user.management') + " - " + AJS.I18n.getText('usermanagement.passwordpolicy.nav'),
        "googleapps": AJS.I18n.getText('usermanagement.application.user.management') + " - " + AJS.I18n.getText('usermanagement.googleapps.nav')
    };

    //add to adminApp
    adminApp.addApplication('usermanagement', {
        routes: routes,
        navigation: navigation,
        titleMap: titleMap
    });
})(window.UserManagement = window.UserManagement || {}, window.adminApp);
