(function($) {

    // Defaults for all Select2 instances.
    $.fn.auiSelect2 && $.extend($.fn.auiSelect2.defaults, {
        // Inherit width of input element it's replacing.
        width: "copy",
        // Number of chars before searching starts.
        minimumInputLength: 0,
        // Message displayed when user hasn't typed enough characters.
        // This can probably be generic, that's why it's here.
        formatInputTooShort: function(term, minLength) {
            return AJS.I18n.getText("usermanagement.generic.picker.input.too.short", minLength);
        }
    });

    UserManagement.helpers.select2 = {
        // Browsers don't clear the "placeholder" text until the user
        // has begin typing. Select2 is doing it the old browser way,
        // clearing the placeholder on focus. This brings us back.
        makePlaceholderBehaviourLikeNative: function($element) {
            var $container = $element.select2("container");
            var placeholderText = this.getTransformedElementReference($element).val();

            $container.parent().on("select2-focus select2-blur select2-clearing select2-selecting change select2-removed select2-open select2-close", ".select2-offscreen", function(event) {
                var isEmpty = $(this).select2("val").length == 0;
                var $input = $container.find(".select2-input");
                $input
                    .attr("placeholder", function() {
                        return isEmpty ? placeholderText : "";
                    })
                    .css("width", function() {
                        return isEmpty ? $container.width() : "auto";
                    });
            });
        },

        getTransformedElementReference: function($element) {
            return $("#s2id_" + $element.attr("id") + ".select2-container .select2-input");
        },

        groupsUsersDataTranslator: function(perPage, userFilters) {
            return function (term, page) {
                    return {
                        filter: term,
                        userFilters: userFilters,
                        "max-results": perPage,
                        "start-index": perPage * --page
                    };
                };
        },

        resizeModalBasedOnHeight: function($element, modal) {
            modal.updateHeight();
            $element.on("change", function() {
                var height = modal.height;

                // Don't grow too tall or the "add" + "cancel"
                // buttons will be pushed off the screen.
                if (height > 600) {
                    return;
                }
                modal.updateHeight();
            });
        }
    };

})(AJS.$);