// Proxy style function to memoize values based on arguments.
//
// Has a method "reset" on the function to do cache invalidation.
(function() {

    var hashArguments = function(arguments) {
        return JSON.stringify(arguments);
    };

    UserManagement.helpers.memoize = function(fn) {
        var store = {};
        var response = function() {
            var hashed = hashArguments(arguments);
            return Object.hasOwnProperty.call(store, hashed) ? store[hashed] : (store[hashed] = fn.apply(this, arguments));
        };
        response.reset = function() {
            if (arguments.length) {
                delete store[hashArguments(arguments)];
            } else {
                store = {};
            }
        };
        return response;
    };

})();