(function ($, root) {
    root.helpers = root.helpers || {};

    root.helpers.groups = {
        setupGroupPicker: function (options) {

            options = $.extend({}, options);
            var $element = $(options.$element);
            var PER_PAGE = 20;

            // Can be removed and placed in Soy template
            // once the right param works in AUI.
            $element.addClass("long-field");

            $element.auiSelect2({
                placeholder: AJS.I18n.getText("usermanagement.group.picker.placeholder"),
                multiple: !!options.multiple,
                openOnEnter: false,
                ajax: {
                    url: AJS.contextPath() + "/rest/um/1/group/search",
                    dataType: 'json',
                    quietMillis: 100,
                    data: root.helpers.select2.groupsUsersDataTranslator(PER_PAGE, options.userFilters),
                    results: function (groups) {
                        return {
                            results: _.map(root.helpers.groups.groupSearchFilter(groups), function (group) {
                                return {
                                    text: group.name,
                                    id: group.name
                                };
                            }),
                            more: groups.length === PER_PAGE
                        };
                    }
                },
                // I18n
                formatNoMatches: function () {
                    return AJS.I18n.getText("usermanagement.group.picker.no.groups.found");
                },
                formatSearching: function () {
                    return AJS.I18n.getText("usermanagement.group.picker.searching");
                },
                formatLoadMore: function () {
                    return AJS.I18n.getText("usermanagement.group.picker.loading.more");
                }
            });

            root.helpers.select2.makePlaceholderBehaviourLikeNative($element);

            options.autoFocus && root.helpers.select2.getTransformedElementReference($element).focus();

            return {
                getGroups: function () {
                    return $element.auiSelect2("data");
                }
            }
        },

        groupSearchFilter: function (data) {
            return _.filter(data, function (item) {
                return !item.isUnmodifiable && !_.contains(["_licensed-jira", "_licensed-confluence", "_licensed-fecru", "_licensed-bamboo", "_no-one-at-all"], item.name);
            });
        }
    };

})(AJS.$, window.UserManagement = window.UserManagement || {});