(function () {
    var DATE_TIME_FORMAT = "D MMM YYYY h:mmA";

    /**
     * Formats a timestamp into a human readable string
     * @param input
     * @param {function(string): string=} i18n an optional function to internationalize the resulting timestamp
     */
    AJS.namespace("UserManagement.helpers.formatDateTime", function (input, i18n) {
        var m = moment(input);
        return {
            isoString: m.toISOString(),
            string: i18n ? i18n(m.format(DATE_TIME_FORMAT)) : m.format(DATE_TIME_FORMAT)
        };
    });

    /**
     * Formats a timestamp into a relative human readable string
     * @param input
     * @param {function(string): string=} i18n an optional function to internationalize the resulting timestamp
     */
    AJS.namespace("UserManagement.helpers.relativeTime", function (input, i18n) {
        var m = moment(input);
        return {
            title: m.format(DATE_TIME_FORMAT),
            isoString: m.toISOString(),
            string: i18n ? i18n(m.fromNow()) : m.fromNow()
        };
    });

    /**
     * Indicates whether a given timestamp is in the future
     * @param input
     */
    AJS.namespace("UserManagement.helpers.isFuture", function (input) {
        return moment(input).isAfter();
    });
})();