(function($, root) {
    root.helpers = root.helpers || {};

    root.helpers.applicationDataMappers = {
        translations: {
            unlimitedLicense: function () {
                return AJS.I18n.getText('usermanagement.apps.unlimited.license');
            },
            seatsTakenWithLimit: function (seatsUsed, seatsLicenced) {
                return AJS.I18n.getText('usermanagement.apps.seats.taken.with.limit', seatsUsed, seatsLicenced);
            },
            seatsTaken: function (seatsTaken) {
                return AJS.I18n.getText('usermanagement.apps.seats.taken', seatsTaken);
            },
            genericError: function () {
                return AJS.I18n.getText('usermanagement.application.unknown.error');
            }
        },

        /**
         * @param options.products
         * @param options.autoUpgradeMode
         */
        productsToSeatsAvailableMessages: function(options) {
            var seatsAvailable = {};
            $.each(options.products, function(i, product) {
                seatsAvailable[product.name] =
                    root.helpers.applicationDataMappers.productToSeatsAvailableMessage(product, options.autoUpgradeMode);
            });
            return seatsAvailable;
        },
        
        productToSeatsAvailableMessage: function (product, autoUpgradeMode, hideLicenceDetails) {
            var translations = root.helpers.applicationDataMappers.translations;
            if (autoUpgradeMode.errorGettingValue) {
                return translations.genericError();
            } else if (product.error) {
                return product.error.reason;
            } else if (!hideLicenceDetails) {
                if (autoUpgradeMode.enabled) {
                    return translations.seatsTaken(product.seatsTaken);
                } else if (product.unlimited) {
                    return translations.unlimitedLicense();
                } else if (!$.isNumeric(product.seatsAvailable)) {
                    return translations.genericError();
                } else if (product.seatsTaken >= 0) {
                    return translations.seatsTakenWithLimit(product.seatsTaken, product.seatsTaken + product.seatsAvailable);
                } else {
                    return translations.genericError();
                }
            }
            return '';
        },

        /**
         * @param options.applications
         * @param options.autoUpgradeMode
         * @param [options.accessLevels]
         * @param [options.disableAll]
         * @param [options.hideLicenceDetails]
         */
        formatApplications: function(options) {
            return $.map(options.applications, function (app) {
                var isChecked,
                    isDisabled;
                var isUnlimited = app.seatsAvailable === undefined;

                // If we have access levels, check applications based on user access
                //      - Disable if no more seats are remaining, as long as user doesn't already have access
                // Otherwise, check applications based on default applications
                //      - Disable if no more seats are remaining, regardless of app defaults
                if (options.accessLevels) {
                    isChecked = options.accessLevels[app.id] && options.accessLevels[app.id] !== "NONE";
                    isDisabled = options.disableAll || (!isChecked && !isUnlimited && app.seatsAvailable < 1);
                } else {
                    isDisabled = options.disableAll || (!isUnlimited && app.seatsAvailable < 1);
                    isChecked = app.isDefault && !isDisabled;
                }

                var seatsAvailableMessage = root.helpers.applicationDataMappers.productToSeatsAvailableMessage(app, options.autoUpgradeMode, options.hideLicenceDetails);
                var labelText = app.name;
                if (seatsAvailableMessage) {
                    labelText += ' (' + seatsAvailableMessage + ')';
                }

                return {
                    name: app.name,
                    type: app.description,
                    id: app.id,
                    value: app.id,
                    labelText: labelText,
                    isChecked: isChecked,
                    isDisabled: isDisabled
                };
            });
        },
        filterApplicationWithAvailableSeats: function(apps) {
            return $.map(apps, function(app) {
                if (app.seatsAvailable === undefined || app.seatsAvailable > 0) {
                    return app.id;
                }
                return null;
            });
        },
        formatGroups: function(applications) {
            return $.merge([{
                text: AJS.I18n.getText("usermanagement.apps.allusers"),
                value: "all"
            }], $.map(applications, function (app) {
                return {
                    text: AJS.I18n.getText("usermanagement.apps.allusers.of", app.name),
                    value: app.id
                };
            }));
        }
    };

})(AJS.$, window.UserManagement = window.UserManagement || {});