(function($, root) {
    root.helpers = root.helpers || {};
    root.helpers.ajax = {
        getApplications: function () {
            var deferred = $.Deferred();

            $.getJSON(AJS.contextPath() + '/rest/um/1/apps/defaults').done(function (data) {
                deferred.resolve(data);
            });

            return deferred.promise();
        },
        getApplicationWithSeats: function () {
            var deferred = $.Deferred();

            $.getJSON(AJS.contextPath() + '/rest/um/1/apps/seats').done(function (data) {
                deferred.resolve(data);
            });

            return deferred.promise();
        },
        getPasswordPolicy: function(){
            return $.getJSON(AJS.contextPath() + '/rest/um/1/passwordpolicy');
        },
        getLicenseUsage: function () {
            return $.when(root.helpers.ajax.getApplicationWithSeats(), root.helpers.ajax.getAutoUpgradeMode()).then(function (products, autoUpgradeMode) {
                return {
                    products: products,
                    autoUpgradeMode: autoUpgradeMode
                };
            });
        },
        getAutoUpgradeMode: function () {
            return $.getJSON(AJS.contextPath() + '/rest/billing/1/instance/is-auto-upgrade').then(function (response) {
                return $.when({
                    enabled: !!(response && response.autoUpgrade),
                    errorGettingValue: false
                });
            }, function (error) {
                return $.when({
                    enabled: false,
                    errorGettingValue: error.status !== 404
                });
            });
        }
    };
})(AJS.$, window.UserManagement = window.UserManagement || {});