(function ($, root) {
    var UMFlashData = root.UMFlashData;
    // This namespace is already qualified by the UMFlashData prefix.
    var SESSION_STORAGE_NAMESPACE = "message.";
    var flashMessageClass = 'flash-message';

    var UMFlashMessage = function (type, options) {
        var messages = UMFlashData.get(SESSION_STORAGE_NAMESPACE) || [];
        messages.push($.makeArray(arguments));
        UMFlashData.set(SESSION_STORAGE_NAMESPACE, messages);
    };

    UMFlashMessage.get = function (container, insertionMethod) {

        var messageOptions = UMFlashData.get(SESSION_STORAGE_NAMESPACE) || [];

        if (!messageOptions.length) {
            return;
        }

        UMFlashMessage.clear(container);

        $.each(messageOptions, function(index, message){
            var type = message.shift();
            message.unshift(container);
            message[1].insert = insertionMethod;

            AJS.messages[type].apply(AJS.messages, message).addClass(flashMessageClass);
        });

        UMFlashData.remove(SESSION_STORAGE_NAMESPACE);
        $(document).trigger("UMFlashMessageInserted", messageOptions);
    };

    UMFlashMessage.clear = function (container) {
        $(container).find('.' + flashMessageClass).remove();
    };

    UMFlashMessage.messageClass = flashMessageClass;

    root.UMFlashMessage = UMFlashMessage;

})(AJS.$, window.UserManagement = window.UserManagement || {});